// Plik: r07/serverAppWithServiceSpec.js
describe('Integracja aplikacji serwerowej', function() {
  beforeEach(module('serverApp2'));

  var ctrl, mockBackend;

  beforeEach(inject(function($controller, $httpBackend) {

    mockBackend = $httpBackend;
    mockBackend.expectGET('/api/note')
        .respond(404, {msg: 'Nie znaleziono'});
    ctrl = $controller('MainCtrl');
    // w tym miejscu wywołanie serwerowe zostało już wykonane
  }));

  it('Powinien obsłużyć błąd podczas ładowania elementów.', function() {
    // początkowo, zamin nadejdzie odpowiedź od serwera,
    // tablica items powinna być pusta
    expect(ctrl.items).toEqual([]);

    // symulacja odpowiedzi serwera
    mockBackend.flush();

    // brak elementów od serwera, tylko błąd
    // tablica items nadal powinna być pusta
    expect(ctrl.items).toEqual([]);
    // sprawdzenie wiadomości o błędzie
    expect(ctrl.errorMessage).toEqual('Nie znaleziono');
  });

  afterEach(function() {
    // sprawdzenie czy wszystkie oczekiwania dotyczące $httpBackend
    // zostały wywołane
    mockBackend.verifyNoOutstandingExpectation();

    // sprawdzenie czy na wszystkie żądania do serwera
    // nadeszła odpowiedź (przy użyciu funkcji flush())
    mockBackend.verifyNoOutstandingRequest();
  });
});
