// Plik: r07/serverAppSpec.js

describe('Wywołania serwerowe MainCtrl', function() {
  beforeEach(module('serverApp'));

  var ctrl, mockBackend;

  beforeEach(inject(function($controller, $httpBackend) {

    mockBackend = $httpBackend;
    mockBackend.expectGET('/api/note')
        .respond([{id: 1, label: 'Imitacja'}]);
    ctrl = $controller('MainCtrl');
    // w tym miejscu żądanie do serwera jest już wysłane
  }));

  it('Powinien ładować elementy z serwera.', function() {
    // Początkowo, przed nadejściem odpowiedzi od serwera,
    // tablica items powinna być pusta.
    expect(ctrl.items).toEqual([]);

    // symulacja odpowiedzi od serwera
    mockBackend.flush();

    expect(ctrl.items).toEqual([{id: 1, label: 'Imitacja'}]);
  });

  afterEach(function() {
    // upewnienie się, że wszystkie bloki expect dla $httpBackend
    // zostały wykonane
    mockBackend.verifyNoOutstandingExpectation();

    // upewnienie się, że na wszystkie żądania do serwera
    // nadeszła odpowiedź (przy użyciu funkcji flush())
    mockBackend.verifyNoOutstandingRequest();
  });
});
