// Plik: r14/routingSpecWithPageObjects.js

// Najlepiej gdy obiekty stron znajdują się w osobnych plikach,
// dzięki czemu łatwiej jest ich używać w różnych testach,
// ale w tym przypadku dla ułatwienia wrzuciliśmy wszystkie do jednego worka.

function TeamsListPage() {
  this.open = function() {
    browser.get('/');
  };

  this.getTeamsListRows = function() {
    return element.all(by.repeater('Drużyna w teamListCtrl.teams'));
  };

  this.getRankForRow = function(row) {
    return element(
      by.repeater('Drużyna w teamListCtrl.teams')
        .row(row).column('team.rank'));
  };

  this.getNameForRow = function(row) {
    return element(
      by.repeater('Drużyna w teamListCtrl.teams')
        .row(row).column('team.name'));
  };

  this.isLoginLinkVisible = function() {
    return element(by.css('.login-link')).isDisplayed();
  };

  this.isLogoutLinkVisible = function() {
    return element(by.css('.logout-link')).isDisplayed();
  };
}

describe('Test trasowania na bazie obiektów stron.', function() {

  it('Powinien wyświetlać drużyny na pierwszej stronie.', function() {
    var teamsListPage = new TeamsListPage();

    teamsListPage.open();

    expect(teamsListPage.getTeamsListRows().count()).toEqual(5);

    expect(teamsListPage.getRankForRow(0).getText())
      .toEqual('1');
    expect(teamsListPage.getNameForRow(0).getText())
      .toEqual('Hiszpania');

    expect(teamsListPage.getRankForRow(4).getText())
      .toEqual('5');
    expect(teamsListPage.getNameForRow(4).getText())
      .toEqual('Urugwaj');

    // sprawdzenie czy odnośnik logowania jest widoczny,
    // a odnośnik wylogowywania jest ukryty
    expect(teamsListPage.isLoginLinkVisible()).toBe(true);
    expect(teamsListPage.isLogoutLinkVisible()).toBe(false);
  });
});
