// Plik: r12/stockDirectiveRenderSpec.js
describe('Renderowanie dyrektywy widżetu giełdowego', function() {

  beforeEach(module('stockMarketApp'));

  var compile, mockBackend, rootScope;

  // krok 1
  beforeEach(inject(function($compile, $httpBackend, $rootScope) {
    compile = $compile;
    mockBackend = $httpBackend;
    rootScope = $rootScope;
  }));

  it('Powinien zostać wyrenderowany HTML na podstawie zakresu.', function() {
    // krok 2
    var scope = rootScope.$new();
    scope.myStock = {
      name: 'Najlepszy towar',
      price: 100,
      previous: 200
    };
    scope.title = 'najlepszy';

    // krok 3
    mockBackend.expectGET('stock.html').respond(
      '<div ng-bind="stockTitle"></div>' +
      '<div ng-bind="stockData.price"></div>');

    // krok 4
    var element = compile('<div stock-widget' +
      ' stock-data="myStock"' +
      ' stock-title="To jest {{title}}"></div>')(scope);

    // krok 5
    scope.$digest();
    mockBackend.flush();

    // krok 6
    expect(element.html()).toEqual(
      '<div ng-bind="stockTitle" class="ng-binding">' +
        'To jest najlepsze' +
      '</div>' +
      '<div ng-bind="stockData.price" class="ng-binding">' +
        '100' +
      '</div>');
  });
});
