﻿/* Lista ćwiczeń
   Aby zaimportować listę ćwiczeń należy użyć narzędzia, które potrafi wykonywać żądania POST. W poniższej instrukcji zostało zastosowane rozszerzenie POSTMAN dla przeglądarki Google Chrom. Zamiast niego można także użyć innego narzęzdzie potrafiącego wykonywać żądania HTTP.
   1. Otwórz rozszerzenie POSTMAN i wklej adres URL: https://api.mongolab.com/api/1/databases/<nazwatwojejbazy>/collections/workouts?apiKey=<kluczAPI>
   2. Zaktualizuj adres URL podając w nim nazwę bazy danych (<nazwatwojejbazy>) oraz klucz API (<kluczAPI>).
   3. Z rozwijanej listy akcji wybierz opcję POST.
   4. Na karcie "Body" zaznacz przycisk opcji "raw".
   5. Skopiuj poniższą tablice JSON i wklej ją w obszarze poniżej.
   6. Kliknij kartę "Headers".
   7. Kliknij pole "Header" i zacznij wpisywać "Content-Type" (możesz wybrać tę opcję z listy), następnie w polu "Value" wpisz "application/json".
   8. Kliknij przycisk "Send". 
   9. Sprawdź status odpowiedzi, by przekonać się czy żądanie zostało poprawnie obsłużone.
*/
[{ "_id": "7minworkout", 
   "exercises": [{ "name": "jumpingJacks", "duration": 30 },
                 { "name": "wallSit", "duration": 30 },
                 { "name": "pushUp", "duration": 30 },
                 { "name": "crunches", "duration": 30 },
                 { "name": "stepUpOntoChair", "duration": 30 },
                 { "name": "squat", "duration": 30 },
                 { "name": "tricepdips", "duration": 30 },
                 { "name": "plank", "duration": 30 },
                 { "name": "highKnees", "duration": 30 },
                 { "name": "lunges", "duration": 30 },
                 { "name": "pushupNRotate", "duration": 30 },
                 { "name": "sidePlank", "duration": 30 }
   ], 
   "name": "7minworkout", 
   "title": "7-minutowy trening", 
   "description": "Intensywny trening składający się z 12 ćwiczeń.", 
   "restBetweenExercise": 10 }]

/* Lista ćwiczeń
   Aby zaimportować listę ćwiczeń należy użyć narzędzia, które potrafi wykonywać żądania POST. W poniższej instrukcji zostało zastosowane rozszerzenie POSTMAN dla przeglądarki Google Chrom. Zamiast niego można także użyć innego narzęzdzie potrafiącego wykonywać żądania HTTP.
   1. Otwórz rozszerzenie POSTMAN i wklej adres URL: https://api.mongolab.com/api/1/databases/<nazwatwojejbazy>/collections/exercises?apiKey=<kluczAPI>
   2. Zaktualizuj adres URL podając w nim nazwę bazy danych (<nazwatwojejbazy>) oraz klucz API (<kluczAPI>).
   3. Wykonaj opisane powyżej czynności od 3. do 9. używając poniższych danych JSON.
*/
[{ "_id": "jumpingJacks", 
   "name": "jumpingJacks", 
   "title": "Pajacyki",
   "description": "Pajacyki to proste ćwiczenie fizyczne polegające na podskakiwaniu i wymachiwaniu rękoma.",
   "image": "img/JumpingJacks.png", 
   "nameSound": "content/jumpingjacks.wav", 
   "related": { "videos": ["dmYwZH_BNd0", "BABOdJ-2Z6o", "c4DAnQ6DtF8"] },
   "procedure": "Stań w pozycji wyprostowanej, złącz stopy, a ramiona opuść swobodnie wzdłuż tułowia. <br/> Zegnij lekko kolana, a następnie wyskocz kilkanaście centymetrów w górę. <br/> W wyskoku rozłącz nogi, mniej więcej na szerokość ramion lub nieco szerzej, i jednocześnie wykonaj lekko zgiętymi w łokciach rękoma wymach nad głową. <br/> Po wylądowaniu na podłodze stopy są rozstawione na szerokość ramion, a lekko zgięte, uniesione nad głowę ręce stykają się dłońmi."
   },
 { "_id": "wallSit", 
   "name": "wallSit", 
   "title": "Krzesełko",
   "description": "Krzesełko to popularne ćwiczenie wzmacniające mięsień czworogłowy uda.",
   "image": "img/wallsit.png", 
   "nameSound": "content/wallsit.wav", 
   "related": { "videos": ["y-wV4Venusw", "MMV3v4ap4ro"] },
   "procedure": "Stań przy ścianie, opierając się o nią plecami. <br/>Stopy rozstaw na szerokość ramion i nieco odsuń od ściany. <br/>Następnie, wciąż opierając się o ścianę, zsuwaj tułów w dół aż do momentu, gdy nogi zgięte w kolanach utworzą kąt prosty. <br/>Wytrzymaj chwilę w tej pozycji."
   },
 { "_id": "crunches", 
   "name": "crunches", 
   "title": "Napinanie brzucha",
   "description": "Proste napinanie mięśni brzucha jest podstawowym ćwiczeniem programu wzmacniającego.",
   "image": "img/crunches.png", 
   "nameSound": "content/crunches.wav", 
   "related": { "videos": ["Xyd_fa5zoEU", "MKmrqcoCZ-M"] },
   "procedure": "Połóż się na plecach, zegnij nogi w kolanach i postaw stopy rozsunięte na szerokość bioder na podłodze. Oprzyj dłonie z tyłu głowy tak, by kciuki znalazły się za uszami. Łokcie rozchyl na boki i lekko unieś. Delikatnie napnij mięśnie brzucha i unieś, odrywając od podłogi, tylko głowę, szyję oraz ramiona. Utrzymaj przez chwilę taką pozycję, a następnie z powrotem opuść górną część ciała na podłogę."
   },
 { "_id": "stepUpOntoChair", 
   "name": "stepUpOntoChair", 
   "title": "Wchodzenie na krzesło",
   "description": "Wchodzenie na krzesło jest doskonałym ćwiczeniem do budowania mięśni dolnych partii ciała.",
   "image": "img/stepUpOntoChair.png", 
   "nameSound": "content/stepup.wav", 
   "related": { "videos": ["aajhW7DD1EA"] }, 
   "procedure": "Ustaw krzesło przed sobą. Stań w lekkim rozkroku, tak aby stopy były oddalone od siebie na szerokość ramion, a ręce opuść swobodnie wzdłuż ciała. Postaw jedną stopę na krześle, a następnie wejdź na krzesło, dostawiając drugą stopę. Zejdź z krzesła, zaczynając do pierwszej stopy, potem zdejmij z niego drugą stopę i stań w pozycji wyjściowej."
   },
 { "_id": "tricepdips", 
   "name": "tricepdips", 
   "title": "Pompki w podporze tyłem",
   "description": "Pompki w podporze tyłem to ćwiczenie na masę mięśniową trenujące głównie triceps.",
   "image": "img/tricepdips.png", 
   "nameSound": "content/tricepdips.wav", 
   "related": { "videos": ["tKjcgfu44sI", "jox1rb5krQI"] }, 
   "procedure": "Usiądź na krześle. Nogi lekko wyprostuj, a stopy postaw płasko na podłodze. Oprzyj śródręcze dłoni tuż przy krawędzi krzesła, tak aby palce były skierowane pionowo w dół. Nie poruszając nogami, przesuń pośladki do przodu, poza krzesło. Powoli opuść ciało. Kiedy ręce w łokciach będą zgięte pod kątem 90 stopni, zatrzymaj się, po czym powoli podnieś ciało w górę do pozycji wyjściowej."
   },
 { "_id": "plank", 
   "name": "plank", 
   "title": "Leżenie w podporze",
   "description": "Leżenie w podporze jest jednym z podstawowych siłowych ćwiczeń izometrycznych, polegających na utrzymywaniu trudnej pozycji przez dłuższy czas.",
   "image": "img/plank.png", 
   "nameSound": "content/plank.wav", 
   "related": { "videos": ["pSHjTRCQxIw", "TvxNkmjdhMM"] }, 
   "procedure": "Połóż się na brzuchu i przyjmij pozycję jak podczas robienia pompek. Zegnij łokcie pod kątem 90 stopni i oprzyj ciężar ciała na przedramionach. Łokcie powinny się znajdować bezpośrednio pod barkami, a ciało tworzy linię prostą, zaczynając od głowy, a kończąc na stopach. Wytrzymaj chwilę w tej pozycji."
   },
 { "_id": "highKnees", 
   "name": "highKnees", 
   "title": "Podnoszenie kolan",
   "description": "Podnoszenie kolan, popularnie określane jako skip-A, rozwija siłę i wytrzymałość zginaczy, mięśnia czworogłowego uda oraz mięśni prostowników uda.",
   "image": "img/highknees.png", 
   "nameSound": "content/highknees.wav", 
   "related": { "videos": ["OAJ_J3EZkdY", "8opcQdC-V-U"] }, 
   "procedure": "Stań prosto w rozkroku na szerokość ramion. Podnieś kolano w górę, dociągając je maksymalnie do klatki piersiowej. Powtórz ćwiczenie na drugą nogę."
   },
 { "_id": "lunges", 
   "name": "lunges", 
   "title": "Wypady",
   "description": "Wypady są dobrym ćwiczeniem do wzmacniania, rzeźbienia i budowania kilku grup mięśni, w tym mięśnia czworogłowego, mięśni pośladkowych, jak również ścięgien podkolanowych.",
   "image": "img/lunges.png", 
   "nameSound": "content/lunge.wav", 
   "related": { "videos": ["Z2n58m2i4jg"] }, 
   "procedure": "Stań prosto w rozkroku na szerokość ramion. Połóż ręce na biodrach, wyprostuj plecy, rozluźnij ramiona i patrz przed siebie. Jedną nogą zrób duży wykrok w przód. W trakcie wykonywania wykroku zniż biodra i zegnij nogi w kolanach tak, by łydki i uda tworzyły kąt prosty. Wróć do pozycji wyjściowej. Powtórz ćwiczenie na drugą nogę."
   },
 { "_id": "pushupNRotate", 
   "name": "pushupNRotate", 
   "title": "Pompki z obrotem",
   "description": "Pompki z obrotem to wersja pompek wymagająca dodatkowo wykonania obrotu.",
   "image": "img/pushupNRotate.png", 
   "nameSound": "content/pushupandrotate.wav", 
   "related": { "videos": ["qHQ_E-f5278"] }, 
   "procedure": "Przyjmij klasyczną pozycję do pompek, ale podczas podnoszenia się obróć się tak, by wyprostowana prawa ręka znalazła się w górze nad głową. Wróć do pozycji wyjściowej, a następnie powtórz ćwiczenie, wyciągając ku górze lewą rękę."
   },
 { "_id": "sidePlank", 
   "name": "sidePlank", 
   "title": "Unoszenie bioder bokiem",
   "description": "Unoszenie bioder bokiem to wariant leżenia w podporze wykonywany w pozycji bocznej.",
   "image": "img/sideplank.png", 
   "nameSound": "content/sideplank.wav", 
   "related": { "videos": ["wqzrb67Dwf8", "_rdfjFSFKMY"] },
   "procedure": "Połóż się na boku tak, aby ciało tworzyło linię prostą od głowy do stóp, opierając ciężar na przedramieniu. Łokieć powinien się znajdować bezpośrednio poniżej barku. Ściśnij lekko pośladki i delikatnie unieś biodra, zachowując linię prostą ciała. Trzymaj biodra prosto, a szyję w jednej linii z kręgosłupem. Wytrzymaj chwilę w takiej pozycji."
   },
 { "_id": "pushUp", 
   "name": "pushUp", 
   "title": "Pompki",
   "description": "Pompki to popularne ćwiczenie wykonywane w pozycji leżącej na brzuchu, polegające na podnoszeniu i opuszczaniu ciała na rękach.",
   "image": "img/pushup.png", 
   "nameSound": "content/pushups.wav", 
   "related": { "videos": ["Eh00_rniF8E", "ZWdBqFLNljc", "UwRLWMcOdwI", "ynPwl6qyUNM", "OicNTT2xzMI"] },
   "procedure": "Połóż się na brzuchu, zegnij ręce w łokciach, a dłonie rozstawione na szerokość ramion lub nieco szerzej oprzyj na podłodze. Utrzymując ciało w jednej linii, podnieś się na rękach, aż do ich całkowitego wyprostowania. Wciąż zachowując linię prostą ciała, opuść się ku ziemi, zginając ręce w łokciach."
   },
 { "_id": "squat", 
   "name": "squat", 
   "title": "Przysiady",
   "description": "Przysiady są złożonym ćwiczeniem obejmującym wiele partii ciała i trenującym głównie mięśnie ud, bioder i pośladków.",
   "image": "img/squat.png", 
   "nameSound": "content/squats.wav", 
   "related": { "videos": ["QKKZ9AGYTi4", "UXJrBgI2RxA"] }, 
   "procedure": "Stań prosto w rozkroku na szerokość ramion, klatkę piersiową wypnij do przodu. Wyciągnij ręce w poziomie przed siebie. Zginając kolana, obniżaj ciało tak, jakbyś chciał usiąść na krześle. Trzymaj głowę prosto i patrz przed siebie, pochylając jednocześnie górną część ciała do przodu. Nie wyginaj tułowia w łuk, a jedynie nieznacznie wypnij go w dolnej części ku przodowi. Zginaj kolana do momentu, gdy uda ustawią się równolegle do podłogi, a kolana znajdą się nad kostkami. Przenieś ciężar ciała na pięty. Napnij mięśnie, a następnie podnieś się do pozycji wyjściowej."
}]