// Plik konfiguracyjny Karma

module.exports = function(config) {
  config.set({

    // ścieżka bazowa używana do wyznaczania wszystkich wzorców (plików, itd.)
    basePath: '../',


    // używane frameworki
    // dostępne frameworki: https://npmjs.org/browse/keyword/karma-adapter
    frameworks: ['jasmine'],


    // lista plików / wzorców do wczytania do przeglądarki
    files: [
        'app/bower_components/angular/angular.js',
        'app/bower_components/angular-route/angular-route.js',
        'app/bower_components/angular-resource/angular-resource.js',
        'app/bower_components/angular-sanitize/angular-sanitize.js',
        'app/bower_components/angular-animate/angular-animate.js',
        'app/bower_components/angular-mocks/angular-mocks.js',
        'app/bower_components/angular-messages/angular-messages.js',
        'app/bower_components/angular-bootstrap/ui-bootstrap-tpls.js',
        'app/bower_components/angular-media-player/dist/angular-media-player.js',
        'app/bower_components/angular-local-storage/dist/angular-local-storage.js',
        'app/js/app.js',
        'app/js/root.js',
        'app/js/7MinWorkout/*.js',
        'app/js/shared/*.js',
        'app/js/WorkoutBuilder/*.js',
        'app/js/config.js',
        'app/js/config.spec.js',
        'app/partials/**/*.html',
    ],


    // lista plików do pominięcia
    exclude: [
        'app/js/vendor/*.*'
    ],


    // pliki do wstępnego przetworzenia przed ich przesłaniem do przeglądarki
    // lista dostępnych preprocesorów: https://npmjs.org/browse/keyword/karma-preprocessor
    preprocessors: {
        'app/partials/**/*.html': ['ng-html2js']
    },

    ngHtml2JsPreprocessor: {
      // ten łańcuch należy usuwać ze ścieżek
      stripPrefix: 'app',
    },
    

    // używany mechanizm raportowania wyników
    // dostępne wartości: 'dots', 'progress'
    // lista dostępnych mechanizmów: https://npmjs.org/browse/keyword/karma-reporter
    reporters: ['progress'],


    // port serwera
    port: 9876,


    // włącza/wyłącznia stosowanie kolorów w wynikach (raportach i dziennikach)
    colors: true,


    // pozmiom rejestracji danych w dziennikach
    // dostępne wartości: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    logLevel: config.LOG_INFO,


    // włącza/wyłacza obserwowanie zmian w plikach i wykonywanie testów po wykryciu jakiejś zmiany
    autoWatch: true,


    // lista uruchamianych przeglądarek
    // lista dostępnych mechanizmów do uruchamiania przeglądarek: https://npmjs.org/browse/keyword/karma-launcher
    browsers: ['Chrome'],


    // tryb ciągłej integracji (Continuous Integration)
    // w razie zastosowania wartości true, Karma przechwytuje przeglądarki, wykonuje testy i kończy działanie
    singleRun: false
  });
};
