import {Component, ViewEncapsulation, Input, HostBinding} from '@angular/core';
import template from './activity.html!text';

@Component({
  selector: 'ngc-activity',
  host: {
    class: 'activity'
  },
  template,
  encapsulation: ViewEncapsulation.None
})
export class Activity {
  @Input() activity;
  // Właściwość wejściowa z wartością tekstową 'left' lub 'right', która określi wyrównanie aktywności poprzez CSS.
  @Input() alignment;
  @Input() @HostBinding('class.activity--start-mark') startMark;
  @Input() @HostBinding('class.activity--end-mark') endMark;

  // Funkcja informująca, czy należy wyrównywać do prawej. Użyana do włączania klasy modyfikującej w elemencie komponentu.
  isAlignedRight() {
    return this.alignment === 'right';
  }
}
