import {Pipe, Inject} from '@angular/core';
import {formatDuration} from '../utilities/time-utilities';

@Pipe({
  name: 'formatEfforts'
})
export class FormatEffortsPipe {
  // Metoda transform zostanie wywołana po użyciu potoku w szablonie komponentu.
  transform(value) {
    if (value == null || typeof value !== 'object') {
      return value;
    }

    return `${formatDuration(value.effective) || 'brak'} z ${formatDuration(value.estimated) || 'nie wyestymowano'}`;
  }
}
