import {Tag} from './tag';
import {limitWithEllipsis} from '../utilities/string-utilities';
export const TAG_TYPE_PROJECT = 'project';

// Funkcja generateTag odpowiada za generowanie nowych obiektów znaczników w sposób zależny od przekazanego obiektu.
export function generateTag(subject) {
  if (subject.type === TAG_TYPE_PROJECT) {
    // Jeśli przekazany typ obiektu to projekt, wygenerują odpowiednią etykietę.
    const openTaskCount = subject.tasks.filter((task) => !task.done).length;
    return new Tag(
      `#${subject._id}`,
      `${limitWithEllipsis(subject.title, 20)} (${openTaskCount} otwartych zadań)`,
      `#/projects/${subject._id}/tasks`,
      TAG_TYPE_PROJECT
    );
  }
}
