import {Component, ViewEncapsulation, Inject} from '@angular/core';
import template from './agile-task-detail.html!text';
import {PluginData} from '../../../lib/plugin/plugin';
import {Project} from '../../../lib/project/project';
import {ProjectTaskDetails} from '../../../lib/project/project-task-details/project-task-details';

@Component({
  selector: 'ngc-agile-task-detail',
  encapsulation: ViewEncapsulation.None,
  template,
  host: {
    class: 'agile-task-detail'
  }
})
export class AgileTaskDetail {
  constructor(@Inject(Project) project, @Inject(ProjectTaskDetails) projectTaskDetails, @Inject(PluginData) pluginData) {
    // Używamy referencji do projektu, aby aktualizować dokument z projektami.
    this.project = project;
    // Referencja do komponentu ProjectTaskDetails, w którym znalazł siękomponent plug-inu, pozwoli uzyskać obiekt szczegółów zadania.
    this.projectTaskDetails = projectTaskDetails;
    // Pobranie egzemplarza plug-inu, w którym w centralny sposób przechowujemy listę wycen w SP.
    this.plugin = pluginData.plugin.instance;
  }

  // Zostanie wywołana przez komponent edytora.
  onStoryPointsSaved(storyPoints) {
    // Ustawiamy wartość storyPoints bezpośrednio w obiekcie danych zadania komponentu ProjectTaskDetails.
    this.projectTaskDetails.task.storyPoints = +storyPoints || 0;
    // Zapisujemy dane projektu używając referencji do komponentu projektu.
    this.project.document.persist();
  }

  increaseStoryPoints() {
    // Znajdź następną wyższą wartość wyceny i umieść ją w obiekcie danych zadania.
    const current = this.projectTaskDetails.task.storyPoints || 0;
    const storyPoints = this.plugin.storyPoints.slice().sort((a, b) => a > b ? 1 : a < b ? -1 : 0);
    this.projectTaskDetails.task.storyPoints =
      storyPoints.find((storyPoints) => storyPoints > current) || current;
    // Zapisujemy dane projektu używając referencji do komponentu projektu.
    this.project.document.persist();
  }

  decreaseStoryPoints() {
    // Znajdź następną niższą wartość wyceny i umieść ją w obiekcie danych zadania.
    const current = this.projectTaskDetails.task.storyPoints || 0;
    const storyPoints = this.plugin.storyPoints.slice().sort((a, b) => a < b ? 1 : a > b ? -1 : 0);
    this.projectTaskDetails.task.storyPoints =
      storyPoints.find((storyPoints) => storyPoints < current) || current;
    // Zapisujemy dane projektu używając referencji do komponentu projektu.
    this.project.document.persist();
  }
}
