import { NgModule } from '@angular/core';

// Wczytaj moduł zawierający podstawowe dyrektywy.
import {CommonModule} from '@angular/common';

// Wczytaj moduł zawierający komponenty interfejsu użytkownika.
import {UIModule} from '../ui/ui.module';

import {DraggableModule} from '../draggable/draggable.module'

// Wczytaj listę zadań i zadanie jako zależności modułu.
import {TaskList} from './task-list';
import {Task} from './task/task';

// Komponent do wpisywania nowych zadań.
import {EnterTask} from './enter-task/enter-task';

import {InfiniteScroll} from '../infinite-scroll/infinite-scroll';

import {RouterModule} from '@angular/router';
import {TaskInfos} from "./task/task-infos/task-infos";
import {TaskInfo} from "./task/task-infos/task-info/task-info";
import {PipesModule} from "../pipes/pipes.module";
import {PluginModule} from "../plugin/plugin.module";

// Utwórz moduł listy zadań.
@NgModule({
  declarations: [TaskList, Task, EnterTask, InfiniteScroll, TaskInfos, TaskInfo],
  imports: [CommonModule, UIModule, DraggableModule, RouterModule, PipesModule, PluginModule],
  exports: [TaskList]
})
export class TaskListModule {}
