import { NgModule } from '@angular/core';
import {RouterModule} from '@angular/router';
import {ProjectTaskList} from './project-task-list/project-task-list';
import {ProjectComments} from './project-comments/project-comments';
import {ProjectActivities} from './project-activities/project-activities';
import {ProjectTaskDetails} from './project-task-details/project-task-details';
import {Project} from './project';

// Utwórz moduł routingu projektu.
@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: 'projects/:projectId',
        component: Project,
        children: [
          { path: '', redirectTo: 'tasks', pathMatch: 'full'},
          { path: 'tasks', component: ProjectTaskList},
          { path: 'comments', component: ProjectComments},
          { path: 'activities', component: ProjectActivities},
          { path: 'task/:nr', component: ProjectTaskDetails}
        ]},
    ])
  ],
  exports: [RouterModule]
})
export class ProjectRoutingModule {}
