# Angular 2. Komponenty - przykładowa aplikacja

To archiwum zawiera kod źródłowy aplikacji do zarządzania zadaniami.
Plik archiwum ZIP zawiera 10 folderów z kodem dotyczącym poszczególnych rozdziałów.
Pliki zawierająstan aplikacji na końcu rozdziału.

## Wymagania wstępne

Aplikacja do zarządzania zadaniami wymaga użycia technologii Node.js, więc trzeba zainstalować to środowisko na lokalnym komputerze przed przejściem do dalszej części kodu.

Pobierz i zainstaluj Node.js z witryny http://nodejs.org.

Aby skompilować pliki źródłowe Sass i uruchomić serwer live-reload, zainstaluj globalnie dwa moduły NPM:

```
npm install -g gulp live-server
```

## Użycie

Po pobraniu archiwum i wypakowaniu kodu wybranego rozdziału, zainstaluj zależności dotyczące narzędzi NPM i JSPM.
Wykonując dwa poniższe polecenia, pobierzesz wszystkie zależności.
Oba polecenia wykonaj w rozpakowanym folderze z kodem dotyczącym wybranego rozdziału:

```
npm install
jspm install
```

Po zainstalowaniu wymaganych zależności, uruchom aplikację poleceniem:

```
npm start
```

Skrypt NPM spowoduje skompilowanie plików Sass i uruchomienie statycznego serwera plików live-server.
Pamiętaj o wcześniejszym zainstalowaniu modułów globalnych NPM.

## Czyszczenie danych w bazie Indexed DB

Aplikacja do zarządzania zadaniami używa trwałego magazynu danych znajdującego się w przeglądarce internetowej.
Jeśli często przełączasz się między różnymi rozdziałami i wypróbowujesz dotyczące ich przykłady, istnieje spora szansa na wywołanie niestabilności aplikacji.
Aby wyczyścić bazę danych używaną przez aplikację, wykonaj poniższy kod w konsoli debugowania przeglądarki internetowej.
Ważne jest jednak, aby wcześniej w tym oknie przeglądarki uruchomić przykładową aplikację.
Jeśli przeglądarka będzie wskazywała inny adres, bazy nie uda się usunąć.
Po usunięciu bazy uruchom aplikację ponownie, a baza danych wraz z przykładowymi danymi zostanie automatycznie odtworzona:

```
indexedDB.deleteDatabase('_pouch_angular-2-components');
```
