import {Tag} from './tag';
import {limitWithEllipsis} from '../utilities/string-utilities';
export const TAG_TYPE_PROJECT = 'project';
export const TAG_TYPE_TASK = 'task';

// Funkcja generateTag odpowiada za generowanie nowych obiektów znaczników w sposób zależny od przekazanego obiektu.
export function generateTag(subject) {
  if (subject.type === TAG_TYPE_PROJECT) {
    // Jeśli przekazany typ obiektu to projekt, wygenerują odpowiednią etykietę.
    const openTaskCount = subject.tasks.filter((task) => !task.done).length;
    return new Tag(
      `#${subject._id}`,
      `${limitWithEllipsis(subject.title, 20)} (${openTaskCount} otwartych zadań)`,
      `#/projects/${subject._id}/tasks`,
      TAG_TYPE_PROJECT
    );
  } else if (subject.type === TAG_TYPE_TASK) {
    // Jeśli mamy do czynienia z zadaniem, wygeneruj odpowiedni obiekt etykiety.
    return new Tag(
      `#${subject.project._id}-zadanie-${subject.task.nr}`,
      `${limitWithEllipsis(subject.task.title, 20)} (${subject.task.done ? 'wykonane' : 'otwarte'})`,
      `#/projects/${subject.project._id}/task/${subject.task.nr}`,
      TAG_TYPE_TASK
    );
  }
}
