import {PluginConfig, PluginPlacement} from '../../lib/plugin/plugin';
import {AgileTaskInfo} from './agile-task-info/agile-task-info';
import {AgileTaskDetail} from './agile-task-detail/agile-task-detail';
import {NgModule} from '@angular/core';
import {CommonModule} from '@angular/common';
import {UIModule} from "../../lib/ui/ui.module";

@NgModule({
  imports: [CommonModule, UIModule],
  declarations: [AgileTaskInfo, AgileTaskDetail]
})
class AgilePluginModule {}

@PluginConfig({
  name: 'agile',
  description: 'Plugin zwinnego zarządzania projektami dodający do zadań pole wyceny w SP',
  module: AgilePluginModule,
  // Informacje o rozmieszczeniu informują system modułów dodatkowych, gdzie wstawić komponenty plug-inu.
  placements: [
    new PluginPlacement({slot: 'task-info', priority: 1, component: AgileTaskInfo}),
    new PluginPlacement({slot: 'task-detail', priority: 1, component: AgileTaskDetail})
  ]
})
export default class AgilePlugin {
  constructor() {
    // Dostępne wyceny w SP umieszczamy w danych plug-inu, aby były dostępne globalnie dla wszystkich komponentów plug-inu.
    this.storyPoints = [0.5, 1, 2, 3, 5, 8, 13, 21];
  }
}
