// Prosty dekorator, który zapisuje pierwszy parametr do konstruktora typu zawierającego adnotację.
export function PluginConfig(config) {
  return (type) => {
    type._pluginConfig = config;
  };
}

// Klasa służąca do konfiguracji rozmieszczenia komponentu z pluginu na podstawie danych z dekoratora @Plugin.
export class PluginPlacement {
  constructor(options) {
    this.slot = options.slot;
    this.priority = options.priority;
    this.component = options.component;
  }
}

// Klasa łączy w sobie dane o rozmieszczeniu z ogólnymi informacjami o plug-inie.
// Posłuży do wstrzykiwania informacji wykonawczych do komponentów plug-inu.
export class PluginData {
  constructor(plugin, placement) {
    this.plugin = plugin;
    this.placement = placement;
  }
}
