// Type definitions for Angular v2.0.0-alpha.26
// Project: http://angular.io/
// Definitions by: angular team <https://github.com/angular/>
// Definitions: https://github.com/borisyankov/DefinitelyTyped

// ***********************************************************
// This file is generated by the Angular build process.
// Please do not create manual edits or send pull requests
// modifying this file.
// ***********************************************************

// Angular depends transitively on these libraries.
// If you don't have them installed you can run
// $ tsd query es6-promise rx rx-lite --action install --save
///<reference path="../es6-promise/es6-promise.d.ts"/>
///<reference path="../rx/rx.d.ts"/>

interface List<T> extends Array<T> {}
interface Map<K,V> {}
interface StringMap<K,V> {}
interface Type {}

declare module "angular2/angular2" {
  type SetterFn = typeof Function;
  type int = number;

  // See https://github.com/Microsoft/TypeScript/issues/1168
  class BaseException /* extends Error */ {
    message: any;
    stack: any;
    toString(): string;
  }
}


declare module "angular2/angular2" {
  class AbstractChangeDetector extends  ChangeDetector {
    addChild(cd: ChangeDetector): any;
    addShadowDomChild(cd: ChangeDetector): any;
    callOnAllChangesDone(): any;
    checkNoChanges(): any;
    detectChanges(): any;
    detectChangesInRecords(throwOnChange: boolean): any;
    lightDomChildren: List<any>;
    markAsCheckOnce(): any;
    markPathToRootAsCheckOnce(): any;
    mode: string;
    parent: ChangeDetector;
    ref: ChangeDetectorRef;
    remove(): any;
    removeChild(cd: ChangeDetector): any;
    removeShadowDomChild(cd: ChangeDetector): any;
    shadowDomChildren: List<any>;
  }
  
  class ProtoRecord {
    args: List<any>;
    bindingRecord: BindingRecord;
    contextIndex: number;
    directiveIndex: DirectiveIndex;
    expressionAsString: string;
    fixedArgs: List<any>;
    funcOrValue: any;
    isLifeCycleRecord(): boolean;
    isPipeRecord(): boolean;
    isPureFunction(): boolean;
    lastInBinding: boolean;
    lastInDirective: boolean;
    mode: number;
    name: string;
    selfIndex: number;
  }
  
  class LifecycleEvent {
    name: string;
  }
  
  interface FormDirective {
    addControl(dir: ControlDirective): void;
    addControlGroup(dir: ControlGroupDirective): void;
    getControl(dir: ControlDirective): Control;
    removeControl(dir: ControlDirective): void;
    removeControlGroup(dir: ControlGroupDirective): void;
    updateModel(dir: ControlDirective, value: any): void;
  }
  

  /**
   * A directive that contains a group of [ControlDirective].
   * 
   * @exportedAs angular2/forms
   */
  class ControlContainerDirective {
    formDirective: FormDirective;
    name: string;
    path: List<string>;
  }
  

  /**
   * A marker annotation that marks a class as available to `Injector` for creation. Used by tooling
   * for generating constructor stubs.
   * 
   * ```
   * class NeedsService {
   *   constructor(svc:UsefulService) {}
   * }
   * 
   * @Injectable
   * class UsefulService {}
   * ```
   * @exportedAs angular2/di_annotations
   */
  class Injectable {
  }
  

  /**
   * Injectable Objects that contains a live list of child directives in the light Dom of a directive.
   * The directives are kept in depth-first pre-order traversal of the DOM.
   * 
   * In the future this class will implement an Observable interface.
   * For now it uses a plain list of observable callbacks.
   * 
   * @exportedAs angular2/view
   */
  class BaseQueryList<T> {
    add(obj: any): any;
    fireCallbacks(): any;
    onChange(callback: any): any;
    removeCallback(callback: any): any;
    reset(newList: any): any;
  }
  
  class AppProtoView {
    bindElement(parent: ElementBinder, distanceToParent: int, protoElementInjector: ProtoElementInjector, componentDirective?: DirectiveBinding): ElementBinder;

    /**
     * Adds an event binding for the last created ElementBinder via bindElement.
     * 
     * If the directive index is a positive integer, the event is evaluated in the context of
     * the given directive.
     * 
     * If the directive index is -1, the event is evaluated in the context of the enclosing view.
     * 
     * @param {string} eventName
     * @param {AST} expression
     * @param {int} directiveIndex The directive index in the binder or -1 when the event is not bound
     *                             to a directive
     */
    bindEvent(eventBindings: List<EventBinding>, boundElementIndex: number, directiveIndex?: int): void;
    elementBinders: List<ElementBinder>;
    protoChangeDetector: ProtoChangeDetector;
    protoLocals: Map<string, any>;
    render: RenderProtoViewRef;
    variableBindings: Map<string, string>;
  }
  

  /**
   * Const of making objects: http://jsperf.com/instantiate-size-of-object
   */
  class AppView implements  ChangeDispatcher,  EventDispatcher {
    callAction(elementIndex: number, actionExpression: string, action: Object): any;
    changeDetector: ChangeDetector;
    componentChildViews: List<AppView>;

    /**
     * The context against which data-binding expressions in this view are evaluated against.
     * This is always a component instance.
     */
    context: any;
    dispatchEvent(elementIndex: number, eventName: string, locals: Map<string, any>): boolean;
    elementInjectors: List<ElementInjector>;
    freeHostViews: List<AppView>;
    getDetectorFor(directive: DirectiveIndex): any;
    getDirectiveFor(directive: DirectiveIndex): any;
    hydrated(): boolean;
    init(changeDetector: ChangeDetector, elementInjectors: List<ElementInjector>, rootElementInjectors: List<ElementInjector>, preBuiltObjects: List<PreBuiltObjects>, componentChildViews: List<AppView>): any;

    /**
     * Variables, local to this view, that can be used in binding expressions (in addition to the
     * context). This is used for thing like `<video #player>` or
     * `<li template="for #item of items">`, where "player" and "item" are locals, respectively.
     */
    locals: Locals;
    notifyOnBinding(b: BindingRecord, currentValue: any): void;
    preBuiltObjects: List<PreBuiltObjects>;
    proto: AppProtoView;
    render: RenderViewRef;
    renderer: Renderer;
    rootElementInjectors: List<ElementInjector>;
    setLocal(contextName: string, value: any): void;

    /**
     * Triggers the event handlers for the element and the directives.
     * 
     * This method is intended to be called from directive EventEmitters.
     * 
     * @param {string} eventName
     * @param {*} eventObj
     * @param {int} binderIndex
     */
    triggerEventHandlers(eventName: string, eventObj: any, binderIndex: int): void;
    viewContainers: List<AppViewContainer>;
  }
  
  class AppViewContainer {
    freeViews: List<AppView>;
    views: List<AppView>;
  }
  
  class Visibility extends  DependencyAnnotation {
    crossComponentBoundaries: boolean;
    depth: number;
    includeSelf: boolean;
  }
  

  /**
   * Entry point for creating, moving views in the view hierarchy and destroying views.
   * This manager contains all recursion and delegates to helper methods
   * in AppViewManagerUtils and the Renderer, so unit tests get simpler.
   */
  class AppViewManager {
    attachViewInContainer(viewContainerLocation: ElementRef, atIndex: number, viewRef: ViewRef): ViewRef;
    createDynamicComponentView(hostLocation: ElementRef, componentProtoViewRef: ProtoViewRef, componentBinding: Binding, injector: Injector): ViewRef;
    createFreeEmbeddedView(location: ElementRef, protoViewRef: ProtoViewRef, injector?: Injector): ViewRef;
    createFreeHostView(parentComponentLocation: ElementRef, hostProtoViewRef: ProtoViewRef, injector: Injector): ViewRef;
    createRootHostView(hostProtoViewRef: ProtoViewRef, overrideSelector: string, injector: Injector): ViewRef;
    createViewInContainer(viewContainerLocation: ElementRef, atIndex: number, protoViewRef: ProtoViewRef, context?: ElementRef, injector?: Injector): ViewRef;
    destroyFreeEmbeddedView(location: ElementRef, viewRef: ViewRef): any;
    destroyFreeHostView(parentComponentLocation: ElementRef, hostViewRef: ViewRef): any;
    destroyRootHostView(hostViewRef: ViewRef): any;
    destroyViewInContainer(viewContainerLocation: ElementRef, atIndex: number): any;
    detachViewInContainer(viewContainerLocation: ElementRef, atIndex: number): ViewRef;
    getComponent(hostLocation: ElementRef): any;
    getComponentView(hostLocation: ElementRef): ViewRef;
    getViewContainer(location: ElementRef): ViewContainerRef;
  }
  
  class Observable {
    observer(generator: any): Object;
  }
  

  /**
   * Use Rx.Observable but provides an adapter to make it work as specified here:
   * https://github.com/jhusain/observable-spec
   * 
   * Once a reference implementation of the spec is available, switch to it.
   */
  class EventEmitter extends  Observable {
    next(value: any): any;
    observer(generator: any): any;
    return(value: any): any;
    throw(error: any): any;
    toRx(): Rx.Observable<any>;
  }
  
  class DomRenderer extends  Renderer {
    attachComponentView(hostViewRef: RenderViewRef, elementIndex: number, componentViewRef: RenderViewRef): any;
    attachViewInContainer(parentViewRef: RenderViewRef, boundElementIndex: number, atIndex: number, viewRef: RenderViewRef): any;
    callAction(viewRef: RenderViewRef, elementIndex: number, actionExpression: string, actionArgs: any): void;
    createRootHostView(hostProtoViewRef: RenderProtoViewRef, hostElementSelector: string): RenderViewRef;
    createView(protoViewRef: RenderProtoViewRef): RenderViewRef;
    dehydrateView(viewRef: RenderViewRef): any;
    destroyView(view: RenderViewRef): any;
    detachComponentView(hostViewRef: RenderViewRef, boundElementIndex: number, componentViewRef: RenderViewRef): any;
    detachFreeView(viewRef: RenderViewRef): any;
    detachViewInContainer(parentViewRef: RenderViewRef, boundElementIndex: number, atIndex: number, viewRef: RenderViewRef): any;
    getRootNodes(viewRef: RenderViewRef): List</*node*/ any>;
    hydrateView(viewRef: RenderViewRef): any;
    setComponentViewRootNodes(componentViewRef: RenderViewRef, rootNodes: List</*node*/ any>): any;
    setElementProperty(viewRef: RenderViewRef, elementIndex: number, propertyName: string, propertyValue: any): void;
    setEventDispatcher(viewRef: RenderViewRef, dispatcher: any): void;
    setText(viewRef: RenderViewRef, textNodeIndex: number, text: string): void;
  }
  
  var DOCUMENT_TOKEN: any;
  
  class ASTWithSource extends  AST {
    assign(context: any, locals: any, value: any): any;
    ast: AST;
    eval(context: any, locals: any): any;
    isAssignable: boolean;
    location: string;
    source: string;
    toString(): string;
    visit(visitor: any): any;
  }
  
  class AST {
    assign(context: any, locals: any, value: any): any;
    eval(context: any, locals: any): any;
    isAssignable: boolean;
    toString(): string;
    visit(visitor: any): any;
  }
  
  class AstTransformer {
    visitAccessMember(ast: AccessMember): any;
    visitAll(asts: List<any>): any;
    visitBinary(ast: Binary): any;
    visitConditional(ast: Conditional): any;
    visitFunctionCall(ast: FunctionCall): any;
    visitImplicitReceiver(ast: ImplicitReceiver): any;
    visitInterpolation(ast: Interpolation): any;
    visitKeyedAccess(ast: KeyedAccess): any;
    visitLiteralArray(ast: LiteralArray): any;
    visitLiteralMap(ast: LiteralMap): any;
    visitLiteralPrimitive(ast: LiteralPrimitive): any;
    visitMethodCall(ast: MethodCall): any;
    visitPipe(ast: Pipe): any;
    visitPrefixNot(ast: PrefixNot): any;
    visitSafeAccessMember(ast: SafeAccessMember): any;
    visitSafeMethodCall(ast: SafeMethodCall): any;
  }
  
  class AccessMember extends  AST {
    assign(context: any, locals: any, value: any): any;
    eval(context: any, locals: any): any;
    getter: Function;
    isAssignable: boolean;
    name: string;
    receiver: AST;
    setter: Function;
    visit(visitor: any): any;
  }
  
  class LiteralArray extends  AST {
    eval(context: any, locals: any): any;
    expressions: List<any>;
    visit(visitor: any): any;
  }
  
  class ImplicitReceiver extends  AST {
    eval(context: any, locals: any): any;
    visit(visitor: any): any;
  }
  
  class Lexer {
    tokenize(text: string): List<any>;
  }
  
  class Parser {
    addPipes(bindingAst: ASTWithSource, pipes: List<string>): ASTWithSource;
    parseAction(input: string, location: any): ASTWithSource;
    parseBinding(input: string, location: any): ASTWithSource;
    parseInterpolation(input: string, location: any): ASTWithSource;
    parseTemplateBindings(input: string, location: any): List<TemplateBinding>;
    wrapLiteralPrimitive(input: string, location: any): ASTWithSource;
  }
  
  class Locals {
    clearValues(): void;
    contains(name: string): boolean;
    current: Map<any, any>;
    get(name: string): any;
    parent: Locals;
    set(name: string, value: any): void;
  }
  
  class ExpressionChangedAfterItHasBeenChecked extends  BaseException {
    message: string;
    toString(): string;
  }
  
  class ChangeDetectionError extends  BaseException {
    location: string;
    message: string;
    originalException: any;
    toString(): string;
  }
  
  class ProtoChangeDetector {
    instantiate(dispatcher: any): ChangeDetector;
  }
  
  class ChangeDispatcher {
    notifyOnBinding(bindingRecord: BindingRecord, value: any): any;
  }
  
  class ChangeDetector {
    addChild(cd: ChangeDetector): any;
    addShadowDomChild(cd: ChangeDetector): any;
    checkNoChanges(): any;
    dehydrate(): any;
    detectChanges(): any;
    hydrate(context: any, locals: Locals, directives: any): any;
    markPathToRootAsCheckOnce(): any;
    mode: string;
    parent: ChangeDetector;
    remove(): any;
    removeChild(cd: ChangeDetector): any;
    removeShadowDomChild(cd: ChangeDetector): any;
  }
  

  /**
   * Interface used by Angular to control the change detection strategy for an application.
   * 
   * Angular implements the following change detection strategies by default:
   * 
   * - <a href='DynamicChangeDetection'>DynamicChangeDetection</a>: slower, but does not require `eval()`.
   * - <a href='JitChangeDetection'>JitChangeDetection</a>: faster, but requires `eval()`.
   * 
   * In JavaScript, you should always use `JitChangeDetection`, unless you are in an environment that
   * has
   * [CSP](https://developer.mozilla.org/en-US/docs/Web/Security/CSP), such as a Chrome Extension.
   * 
   * In Dart, use `DynamicChangeDetection` during development. The Angular transformer generates an
   * analog to the
   * `JitChangeDetection` strategy at compile time.
   * 
   * 
   * See: <a href='DynamicChangeDetection'>DynamicChangeDetection</a>, <a href='JitChangeDetection'>JitChangeDetection</a>
   * 
   * # Example
   * ```javascript
   * bootstrap(MyApp, [bind(ChangeDetection).toClass(DynamicChangeDetection)]);
   * ```
   * @exportedAs angular2/change_detection
   */
  class ChangeDetection {
    createProtoChangeDetector(definition: ChangeDetectorDefinition): ProtoChangeDetector;
  }
  
  class ChangeDetectorDefinition {
    bindingRecords: List<BindingRecord>;
    directiveRecords: List<DirectiveRecord>;
    id: string;
    strategy: string;
    variableNames: List<string>;
  }
  

  /**
   * CHECK_ONCE means that after calling detectChanges the mode of the change detector
   * will become CHECKED.
   */
  var CHECK_ONCE: any;
  

  /**
   * CHECK_ALWAYS means that after calling detectChanges the mode of the change detector
   * will remain CHECK_ALWAYS.
   */
  var CHECK_ALWAYS: any;
  

  /**
   * DETACHED means that the change detector sub tree is not a part of the main tree and
   * should be skipped.
   */
  var DETACHED: any;
  

  /**
   * CHECKED means that the change detector should be skipped until its mode changes to
   * CHECK_ONCE or CHECK_ALWAYS.
   */
  var CHECKED: any;
  

  /**
   * ON_PUSH means that the change detector's mode will be set to CHECK_ONCE during hydration.
   */
  var ON_PUSH: any;
  

  /**
   * DEFAULT means that the change detector's mode will be set to CHECK_ALWAYS during hydration.
   */
  var DEFAULT: any;
  
  class DynamicProtoChangeDetector extends  ProtoChangeDetector {
    definition: ChangeDetectorDefinition;
    instantiate(dispatcher: any): any;
  }
  
  class JitProtoChangeDetector extends  ProtoChangeDetector {
    definition: ChangeDetectorDefinition;
    instantiate(dispatcher: any): any;
  }
  
  class BindingRecord {
    ast: AST;
    callOnChange(): any;
    directiveRecord: DirectiveRecord;
    elementIndex: number;
    implicitReceiver: any;
    isDirective(): any;
    isDirectiveLifecycle(): any;
    isElement(): any;
    isOnPushChangeDetection(): any;
    isTextNode(): any;
    lifecycleEvent: string;
    mode: string;
    propertyName: string;
    setter: SetterFn;
  }
  
  class DirectiveIndex {
    directiveIndex: number;
    elementIndex: number;
    name: any;
  }
  
  class DirectiveRecord {
    callOnAllChangesDone: boolean;
    callOnChange: boolean;
    callOnCheck: boolean;
    callOnInit: boolean;
    changeDetection: string;
    directiveIndex: DirectiveIndex;
    isOnPushChangeDetection(): boolean;
  }
  
  class DynamicChangeDetector extends  AbstractChangeDetector {
    alreadyChecked: boolean;
    callOnAllChangesDone(): any;
    changeControlStrategy: string;
    changes: List<any>;
    dehydrate(): any;
    detectChangesInRecords(throwOnChange: boolean): any;
    directiveRecords: List<any>;
    directives: any;
    dispatcher: any;
    hydrate(context: any, locals: any, directives: any): any;
    hydrated(): boolean;
    locals: any;
    pipeRegistry: PipeRegistry;
    pipes: List<any>;
    prevContexts: List<any>;
    protos: List<ProtoRecord>;
    values: List<any>;
  }
  

  /**
   * Controls change detection.
   * 
   * <a href='/angular2/angular2/ChangeDetectorRef'><code>ChangeDetectorRef</code></a> allows requesting checks for detectors that rely on observables. It
   * also allows detaching and
   * attaching change detector subtrees.
   * 
   * @exportedAs angular2/change_detection
   */
  class ChangeDetectorRef {

    /**
     * Detaches the change detector from the change detector tree.
     * 
     * The detached change detector will not be checked until it is reattached.
     */
    detach(): any;

    /**
     * Reattach the change detector to the change detector tree.
     * 
     * This also requests a check of this change detector. This reattached change detector will be
     * checked during the
     * next change detection run.
     */
    reattach(): any;

    /**
     * Request to check all ON_PUSH ancestors.
     */
    requestCheck(): any;
  }
  
  class PipeRegistry {
    config: any;
    get(type: string, obj: any, cdRef: ChangeDetectorRef): Pipe;
  }
  
  var uninitialized: any;
  

  /**
   * Indicates that the result of a <a href='/angular2/angular2/Pipe'><code>Pipe</code></a> transformation has changed even though the reference
   * has not changed.
   * 
   * The wrapped value will be unwrapped by change detection, and the unwrapped value will be stored.
   * 
   * @exportedAs angular2/pipes
   */
  class WrappedValue {
    wrapped: any;
  }
  

  /**
   * An interface for extending the list of pipes known to Angular.
   * 
   * If you are writing a custom <a href='/angular2/angular2/Pipe'><code>Pipe</code></a>, you must extend this interface.
   * 
   * #Example
   * 
   * ```
   * class DoublePipe extends Pipe {
   *  supports(obj) {
   *    return true;
   *  }
   * 
   *  transform(value) {
   *    return `${value}${value}`;
   *  }
   * }
   * ```
   * 
   * @exportedAs angular2/pipes
   */
  class Pipe {
    onDestroy(): any;
    supports(obj: any): boolean;
    transform(value: any): any;
  }
  
  class PipeFactory {
    create(cdRef: any): Pipe;
    supports(obs: any): boolean;
  }
  

  /**
   * @exportedAs angular2/pipes
   */
  class NullPipe extends  Pipe {
    called: boolean;
    supports(obj: any): any;
    transform(value: any): any;
  }
  

  /**
   * @exportedAs angular2/pipes
   */
  class NullPipeFactory extends  PipeFactory {
    create(cdRef: any): Pipe;
    supports(obj: any): boolean;
  }
  
  var defaultPipes: any;
  

  /**
   * Implements change detection that does not require `eval()`.
   * 
   * This is slower than <a href='JitChangeDetection'>JitChangeDetection</a>.
   * 
   * @exportedAs angular2/change_detection
   */
  class DynamicChangeDetection extends  ChangeDetection {
    createProtoChangeDetector(definition: ChangeDetectorDefinition): ProtoChangeDetector;
    registry: PipeRegistry;
  }
  

  /**
   * Implements faster change detection, by generating source code.
   * 
   * This requires `eval()`. For change detection that does not require `eval()`, see
   * <a href='DynamicChangeDetection'>DynamicChangeDetection</a>.
   * 
   * @exportedAs angular2/change_detection
   */
  class JitChangeDetection extends  ChangeDetection {
    createProtoChangeDetector(definition: ChangeDetectorDefinition): ProtoChangeDetector;
    registry: PipeRegistry;
  }
  

  /**
   * Implements change detection using a map of pregenerated proto detectors.
   * 
   * @exportedAs angular2/change_detection
   */
  class PreGeneratedChangeDetection extends  ChangeDetection {
    createProtoChangeDetector(definition: ChangeDetectorDefinition): ProtoChangeDetector;
    registry: PipeRegistry;
  }
  
  var preGeneratedProtoDetectors: any;
  
  var defaultPipeRegistry : PipeRegistry ;
  

  /**
   * @exportedAs angular2/view
   */
  class ViewRef {
    render: RenderViewRef;
    setLocal(contextName: string, value: any): void;
  }
  

  /**
   * @exportedAs angular2/view
   */
  class ProtoViewRef {
  }
  

  /**
   * @exportedAs angular2/core
   */
  class ViewContainerRef {
    clear(): void;
    create(protoViewRef?: ProtoViewRef, atIndex?: number, context?: ElementRef, injector?: Injector): ViewRef;

    /**
     * The method can be used together with insert to implement a view move, i.e.
     * moving the dom nodes while the directives in the view stay intact.
     */
    detach(atIndex?: number): ViewRef;
    element: ElementRef;
    get(index: number): ViewRef;
    indexOf(viewRef: ViewRef): any;
    insert(viewRef: ViewRef, atIndex?: number): ViewRef;
    length: any;
    remove(atIndex?: number): void;
    viewManager: AppViewManager;
  }
  

  /**
   * @exportedAs angular2/view
   */
  class ElementRef {
    boundElementIndex: number;

    /**
     * Exposes the underlying DOM element.
     * (DEPRECATED way of accessing the DOM, replacement coming)
     */
    domElement: any;

    /**
     * Gets an attribute from the underlying DOM element.
     * (DEPRECATED way of accessing the DOM, replacement coming)
     */
    getAttribute(name: string): string;
    parentView: ViewRef;
  }

  interface _NgZone_initCallbacks {
    /**
     * called before code executes in the inner zone for each VM turn
     */
    onTurnStart?: /*() => void*/ Function;
    /**
     * called at the end of a VM turn if code has executed in the inner
     * zone
     */
    onTurnDone?: /*() => void*/ Function;
    /**
     * called when an exception is thrown by a macro or
     * micro task
     */
    onErrorHandler?: /*(error, stack) => void*/ Function;
  }  

  /**
   * A wrapper around zones that lets you schedule tasks after it has executed a task.
   * 
   * The wrapper maintains an "inner" and an "mount" `Zone`. The application code will executes
   * in the "inner" zone unless `runOutsideAngular` is explicitely called.
   * 
   * A typical application will create a singleton `NgZone`. The outer `Zone` is a fork of the root
   * `Zone`. The default `onTurnDone` runs the Angular change detection.
   * 
   * @exportedAs angular2/core
   */
  class NgZone {

    /**
     * Initializes the zone hooks.
     */
    initCallbacks(arg?: _NgZone_initCallbacks): any;

    /**
     * Runs `fn` in the inner zone and returns whatever it returns.
     * 
     * In a typical app where the inner zone is the Angular zone, this allows one to make use of the
     * Angular's auto digest mechanism.
     * 
     * ```
     * var zone: NgZone = [ref to the application zone];
     * 
     * zone.run(() => {
     *   // the change detection will run after this function and the microtasks it enqueues have
     * executed.
     * });
     * ```
     */
    run(fn: any): any;

    /**
     * Runs `fn` in the outer zone and returns whatever it returns.
     * 
     * In a typical app where the inner zone is the Angular zone, this allows one to escape Angular's
     * auto-digest mechanism.
     * 
     * ```
     * var zone: NgZone = [ref to the application zone];
     * 
     * zone.runOusideAngular(() => {
     *   element.onClick(() => {
     *     // Clicking on the element would not trigger the change detection
     *   });
     * });
     * ```
     */
    runOutsideAngular(fn: any): any;
  }
  

  /**
   * Specifies that an injector should retrieve a dependency from its element.
   * 
   * ## Example
   * 
   * Here is a simple directive that retrieves a dependency from its element.
   * 
   * ```
   * @Directive({
   *   selector: '[dependency]',
   *   properties: [
   *     'id: dependency'
   *   ]
   * })
   * class Dependency {
   *   id:string;
   * }
   * 
   * 
   * @Directive({
   *   selector: '[my-directive]'
   * })
   * class Dependency {
   *   constructor(@Self() dependency:Dependency) {
   *     expect(dependency.id).toEqual(1);
   *   };
   * }
   * ```
   * 
   * We use this with the following HTML template:
   * 
   * ```
   * <div dependency="1" my-directive></div>
   * ```
   * 
   * @exportedAs angular2/annotations
   */
  class SelfAnnotation extends  Visibility {
  }
  

  /**
   * Specifies that an injector should retrieve a dependency from any ancestor element within the same
   * shadow boundary.
   * 
   * An ancestor is any element between the parent element and shadow root.
   * 
   * 
   * ## Example
   * 
   * Here is a simple directive that retrieves a dependency from an ancestor element.
   * 
   * ```
   * @Directive({
   *   selector: '[dependency]',
   *   properties: [
   *     'id: dependency'
   *   ]
   * })
   * class Dependency {
   *   id:string;
   * }
   * 
   * 
   * @Directive({
   *   selector: '[my-directive]'
   * })
   * class Dependency {
   *   constructor(@Ancestor() dependency:Dependency) {
   *     expect(dependency.id).toEqual(2);
   *   };
   * }
   * ```
   * 
   *  We use this with the following HTML template:
   * 
   * ```
   * <div dependency="1">
   *   <div dependency="2">
   *     <div>
   *       <div dependency="3" my-directive></div>
   *     </div>
   *   </div>
   * </div>
   * ```
   * 
   * The `@Ancestor()` annotation in our constructor forces the injector to retrieve the dependency
   * from the
   * nearest ancestor element:
   * - The current element `dependency="3"` is skipped because it is not an ancestor.
   * - Next parent has no directives `<div>`
   * - Next parent has the `Dependency` directive and so the dependency is satisfied.
   * 
   * Angular injects `dependency=2`.
   * 
   * @exportedAs angular2/annotations
   */
  class AncestorAnnotation extends  Visibility {
  }
  

  /**
   * Specifies that an injector should retrieve a dependency from the direct parent.
   * 
   * ## Example
   * 
   * Here is a simple directive that retrieves a dependency from its parent element.
   * 
   * ```
   * @Directive({
   *   selector: '[dependency]',
   *   properties: [
   *     'id: dependency'
   *   ]
   * })
   * class Dependency {
   *   id:string;
   * }
   * 
   * 
   * @Directive({
   *   selector: '[my-directive]'
   * })
   * class Dependency {
   *   constructor(@Parent() dependency:Dependency) {
   *     expect(dependency.id).toEqual(1);
   *   };
   * }
   * ```
   * 
   * We use this with the following HTML template:
   * 
   * ```
   * <div dependency="1">
   *   <div dependency="2" my-directive></div>
   * </div>
   * ```
   * The `@Parent()` annotation in our constructor forces the injector to retrieve the dependency from
   * the
   * parent element (even thought the current element could resolve it): Angular injects
   * `dependency=1`.
   * 
   * @exportedAs angular2/annotations
   */
  class ParentAnnotation extends  Visibility {
  }
  

  /**
   * Specifies that an injector should retrieve a dependency from any ancestor element.
   * 
   * An ancestor is any element between the parent element and shadow root.
   * 
   * 
   * ## Example
   * 
   * Here is a simple directive that retrieves a dependency from an ancestor element.
   * 
   * ```
   * @Directive({
   *   selector: '[dependency]',
   *   properties: [
   *     'id: dependency'
   *   ]
   * })
   * class Dependency {
   *   id:string;
   * }
   * 
   * 
   * @Directive({
   *   selector: '[my-directive]'
   * })
   * class Dependency {
   *   constructor(@Unbounded() dependency:Dependency) {
   *     expect(dependency.id).toEqual(2);
   *   };
   * }
   * ```
   * 
   * @exportedAs angular2/annotations
   */
  class UnboundedAnnotation extends  Visibility {
  }
  
  /**
   * Declares the available HTML templates for an application.
   *
   * Each angular component requires a single `@Component` and at least one `@View` annotation. The
   * `@View` annotation specifies the HTML template to use, and lists the directives that are active
   * within the template.
   *
   * When a component is instantiated, the template is loaded into the component's shadow root, and
   * the expressions and statements in the template are evaluated against the component.
   *
   * For details on the `@Component` annotation, see {@link Component}.
   *
   * ## Example
   *
   * ```
   * @Component({
   *   selector: 'greet'
   * })
   * @View({
   *   template: 'Hello {{name}}!',
   *   directives: [GreetUser, Bold]
   * })
   * class Greet {
   *   name: string;
   *
   *   constructor() {
   *     this.name = 'World';
   *   }
   * }
   * ```
   */
  function View(arg: _ViewArg): (target: any) => any;
  interface _ViewArg {
    /**
     * Specifies a template URL for an angular component.
     *
     * NOTE: either `templateUrl` or `template` should be used, but not both.
     */
    templateUrl?: string;
  
    /**
     * Specifies an inline template for an angular component.
     *
     * NOTE: either `templateUrl` or `template` should be used, but not both.
     */
    template?: string;
  
    /**
     * Specifies a list of directives that can be used within a template.
     *
     * Directives must be listed explicitly to provide proper component encapsulation.
     *
     * ## Example
     *
     * ```javascript
     * @Component({
     *     selector: 'my-component'
     *   })
     * @View({
     *   directives: [For]
     *   template: '
     *   <ul>
     *     <li *ng-for="#item of items">{{item}}</li>
     *   </ul>'
     * })
     * class MyComponent {
     * }
     * ```
     */
    // TODO(tbosch): use Type | Binding | List<any> when Dart supports union types,
    // as otherwise we would need to import Binding type and Dart would warn
    // for an unused import.
    directives?: List<Type | any | List<any>>;
  
    /**
     * Specify a custom renderer for this View.
     * If this is set, neither `template`, `templateURL` nor `directives` are used.
     */
    renderer?: string;
  }
  
  class ViewAnnotation {
  }
  

  /**
   * Bootstrapping for Angular applications.
   * 
   * You instantiate an Angular application by explicitly specifying a component to use as the root
   * component for your
   * application via the `bootstrap()` method.
   * 
   * ## Simple Example
   * 
   * Assuming this `index.html`:
   * 
   * ```html
   * <html>
   *   <!-- load Angular script tags here. -->
   *   <body>
   *     <my-app>loading...</my-app>
   *   </body>
   * </html>
   * ```
   * 
   * An application is bootstrapped inside an existing browser DOM, typically `index.html`. Unlike
   * Angular 1, Angular 2
   * does not compile/process bindings in `index.html`. This is mainly for security reasons, as well
   * as architectural
   * changes in Angular 2. This means that `index.html` can safely be processed using server-side
   * technologies such as
   * bindings. Bindings can thus use double-curly `{{ syntax }}` without collision from Angular 2
   * component double-curly
   * `{{ syntax }}`.
   * 
   * We can use this script code:
   * 
   * ```
   * @Component({
   *    selector: 'my-app'
   * })
   * @View({
   *    template: 'Hello {{ name }}!'
   * })
   * class MyApp {
   *   name:string;
   * 
   *   constructor() {
   *     this.name = 'World';
   *   }
   * }
   * 
   * main() {
   *   return bootstrap(MyApp);
   * }
   * ```
   * 
   * When the app developer invokes `bootstrap()` with the root component `MyApp` as its argument,
   * Angular performs the
   * following tasks:
   * 
   *  1. It uses the component's `selector` property to locate the DOM element which needs to be
   * upgraded into
   *     the angular component.
   *  2. It creates a new child injector (from the platform injector) and configures the injector with
   * the component's
   *     `appInjector`. Optionally, you can also override the injector configuration for an app by
   * invoking
   *     `bootstrap` with the `componentInjectableBindings` argument.
   *  3. It creates a new `Zone` and connects it to the angular application's change detection domain
   * instance.
   *  4. It creates a shadow DOM on the selected component's host element and loads the template into
   * it.
   *  5. It instantiates the specified component.
   *  6. Finally, Angular performs change detection to apply the initial data bindings for the
   * application.
   * 
   * 
   * ## Instantiating Multiple Applications on a Single Page
   * 
   * There are two ways to do this.
   * 
   * 
   * ### Isolated Applications
   * 
   * Angular creates a new application each time that the `bootstrap()` method is invoked. When
   * multiple applications
   * are created for a page, Angular treats each application as independent within an isolated change
   * detection and
   * `Zone` domain. If you need to share data between applications, use the strategy described in the
   * next
   * section, "Applications That Share Change Detection."
   * 
   * 
   * ### Applications That Share Change Detection
   * 
   * If you need to bootstrap multiple applications that share common data, the applications must
   * share a common
   * change detection and zone. To do that, create a meta-component that lists the application
   * components in its template.
   * By only invoking the `bootstrap()` method once, with the meta-component as its argument, you
   * ensure that only a
   * single change detection zone is created and therefore data can be shared across the applications.
   * 
   * 
   * ## Platform Injector
   * 
   * When working within a browser window, there are many singleton resources: cookies, title,
   * location, and others.
   * Angular services that represent these resources must likewise be shared across all Angular
   * applications that
   * occupy the same browser window.  For this reason, Angular creates exactly one global platform
   * injector which stores
   * all shared services, and each angular application injector has the platform injector as its
   * parent.
   * 
   * Each application has its own private injector as well. When there are multiple applications on a
   * page, Angular treats
   * each application injector's services as private to that application.
   * 
   * 
   * # API
   * - `appComponentType`: The root component which should act as the application. This is a reference
   * to a `Type`
   *   which is annotated with `@Component(...)`.
   * - `componentInjectableBindings`: An additional set of bindings that can be added to `appInjector`
   * for the
   * <a href='/angular2/angular2/Component'><code>Component</code></a> to override default injection behavior.
   * - `errorReporter`: `function(exception:any, stackTrace:string)` a default error reporter for
   * unhandled exceptions.
   * 
   * Returns a `Promise` with the application`s private <a href='/angular2/angular2/Injector'><code>Injector</code></a>.
   * 
   * @exportedAs angular2/core
   */
  function bootstrap(appComponentType: Type, componentInjectableBindings?: List<Type | Binding | List<any>>, errorReporter?: Function) : Promise<ApplicationRef> ;
  
  class ApplicationRef {
    dispose(): any;
    hostComponent: any;
    hostComponentType: any;
    injector: any;
  }
  
  var appComponentRefToken : OpaqueToken ;
  
  var appComponentTypeToken : OpaqueToken ;
  

  /**
   * Specifies that a <a href='QueryList'>QueryList</a> should be injected.
   * 
   * See <a href='QueryList'>QueryList</a> for usage and example.
   * 
   * @exportedAs angular2/annotations
   */
  class QueryAnnotation extends  DependencyAnnotation {
    directive: any;
  }
  

  /**
   * Specifies that a constant attribute value should be injected.
   * 
   * The directive can inject constant string literals of host element attributes.
   * 
   * ## Example
   * 
   * Suppose we have an `<input>` element and want to know its `type`.
   * 
   * ```html
   * <input type="text">
   * ```
   * 
   * A decorator can inject string literal `text` like so:
   * 
   * ```javascript
   * @Directive({
   *   selector: `input'
   * })
   * class InputDirective {
   *   constructor(@Attribute('type') type) {
   *     // type would be `text` in this example
   *   }
   * }
   * ```
   * 
   * @exportedAs angular2/annotations
   */
  class AttributeAnnotation extends  DependencyAnnotation {
    attributeName: string;
    token: any;
  }
  

  /**
   * Cache that stores the AppProtoView of the template of a component.
   * Used to prevent duplicate work and resolve cyclic dependencies.
   */
  class CompilerCache {
    clear(): void;
    get(component: Type): AppProtoView;
    set(component: Type, protoView: AppProtoView): void;
  }
  

  /**
   * @exportedAs angular2/view
   */
  class Compiler {
    compile(component: Type): Promise<ProtoViewRef>;
    compileInHost(componentTypeOrBinding: Type | Binding): Promise<ProtoViewRef>;
  }
  

  /**
   * Defines lifecycle method [onChange] called after all of component's bound
   * properties are updated.
   */
  interface OnChange {
    onChange(changes: StringMap<string, any>): void;
  }
  

  /**
   * Defines lifecycle method [onDestroy] called when a directive is being destroyed.
   */
  interface OnDestroy {
    onDestroy(): void;
  }
  

  /**
   * Defines lifecycle method [onCheck] called when a directive is being checked.
   */
  interface OnCheck {
    onCheck(): void;
  }
  

  /**
   * Defines lifecycle method [onInit] called when a directive is being checked the first time.
   */
  interface OnInit {
    onInit(): void;
  }
  

  /**
   * Defines lifecycle method [onAllChangesDone ] called when the bindings of all its children have
   * been changed.
   */
  interface OnAllChangesDone {
    onAllChangesDone(): void;
  }
  

  /**
   * An iterable live list of components in the Light DOM.
   * 
   * Injectable Objects that contains a live list of child directives in the light DOM of a directive.
   * The directives are kept in depth-first pre-order traversal of the DOM.
   * 
   * The `QueryList` is iterable, therefore it can be used in both javascript code with `for..of` loop
   * as well as in
   * template with `*ng-for="of"` directive.
   * 
   * NOTE: In the future this class will implement an `Observable` interface. For now it uses a plain
   * list of observable
   * callbacks.
   * 
   * # Example:
   * 
   * Assume that `<tabs>` component would like to get a list its children which are `<pane>`
   * components as shown in this
   * example:
   * 
   * ```html
   * <tabs>
   *   <pane title="Overview">...</pane>
   *   <pane *ng-for="#o of objects" [title]="o.title">{{o.text}}</pane>
   * </tabs>
   * ```
   * 
   * In the above example the list of `<tabs>` elements needs to get a list of `<pane>` elements so
   * that it could render
   * tabs with the correct titles and in the correct order.
   * 
   * A possible solution would be for a `<pane>` to inject `<tabs>` component and then register itself
   * with `<tabs>`
   * component's on `hydrate` and deregister on `dehydrate` event. While a reasonable approach, this
   * would only work
   * partialy since `*ng-for` could rearange the list of `<pane>` components which would not be
   * reported to `<tabs>`
   * component and thus the list of `<pane>` componets would be out of sync with respect to the list
   * of `<pane>` elements.
   * 
   * A preferred solution is to inject a `QueryList` which is a live list of directives in the
   * component`s light DOM.
   * 
   * ```javascript
   * @Component({
   *   selector: 'tabs'
   * })
   * @View({
   *  template: `
   *    <ul>
   *      <li *ng-for="#pane of panes">{{pane.title}}</li>
   *    </ul>
   *    <content></content>
   *  `
   * })
   * class Tabs {
   *   panes: QueryList<Pane>
   * 
   *   constructor(@Query(Pane) panes:QueryList<Pane>) {
   *     this.panes = panes;
   *   }
   * }
   * 
   * @Component({
   *   selector: 'pane',
   *   properties: ['title']
   * })
   * @View(...)
   * class Pane {
   *   title:string;
   * }
   * ```
   * 
   * @exportedAs angular2/view
   */
  class QueryList<T> extends  BaseQueryList<T> {
    onChange(callback: any): any;
    removeCallback(callback: any): any;
  }
  
  class DirectiveResolver {
    resolve(type: Type): DirectiveAnnotation;
  }
  

  /**
   * @exportedAs angular2/view
   */
  class ComponentRef {
    dispose: Function;
    hostView: ViewRef;
    instance: any;
    location: ElementRef;
  }
  

  /**
   * Service for dynamically loading a Component into an arbitrary position in the internal Angular
   * application tree.
   * 
   * @exportedAs angular2/view
   */
  class DynamicComponentLoader {

    /**
     * Loads a root component that is placed at the first element that matches the
     * component's selector.
     * The loaded component receives injection normally as a hosted view.
     */
    loadAsRoot(typeOrBinding: any, overrideSelector?: any, injector?: Injector): Promise<ComponentRef>;

    /**
     * Loads a component into the location given by the provided ElementRef. The loaded component
     * receives injection as if it in the place of the provided ElementRef.
     */
    loadIntoExistingLocation(typeOrBinding: any, location: ElementRef, injector?: Injector): Promise<ComponentRef>;

    /**
     * Loads a component into a free host view that is not yet attached to
     * a parent on the render side, although it is attached to a parent in the injector hierarchy.
     * The loaded component receives injection normally as a hosted view.
     */
    loadIntoNewLocation(typeOrBinding: any, parentComponentLocation: ElementRef, injector?: Injector): Promise<ComponentRef>;

    /**
     * Loads a component next to the provided ElementRef. The loaded component receives
     * injection normally as a hosted view.
     */
    loadNextToExistingLocation(typeOrBinding: any, location: ElementRef, injector?: Injector): Promise<ComponentRef>;
  }
  
  /**
   * Declare reusable UI building blocks for an application.
   *
   * Each Angular component requires a single `@Component` and at least one `@View` annotation. The
   * `@Component`
   * annotation specifies when a component is instantiated, and which properties and hostListeners it
   * binds to.
   *
   * When a component is instantiated, Angular
   * - creates a shadow DOM for the component.
   * - loads the selected template into the shadow DOM.
   * - creates a child {@link Injector} which is configured with the `appInjector` for the
   * {@link Component}.
   *
   * All template expressions and statements are then evaluated against the component instance.
   *
   * For details on the `@View` annotation, see {@link View}.
   *
   * ## Example
   *
   * ```
   * @Component({
   *   selector: 'greet'
   * })
   * @View({
   *   template: 'Hello {{name}}!'
   * })
   * class Greet {
   *   name: string;
   *
   *   constructor() {
   *     this.name = 'World';
   *   }
   * }
   * ```
   *
   *
   * Dynamically loading a component at runtime:
   *
   * Regular Angular components are statically resolved. Dynamic components allows to resolve a
   * component at runtime
   * instead by providing a placeholder into which a regular Angular component can be dynamically
   * loaded. Once loaded,
   * the dynamically-loaded component becomes permanent and cannot be changed.
   * Dynamic components are declared just like components, but without a `@View` annotation.
   *
   *
   * ## Example
   *
   * Here we have `DynamicComp` which acts as the placeholder for `HelloCmp`. At runtime, the dynamic
   * component
   * `DynamicComp` requests loading of the `HelloCmp` component.
   *
   * There is nothing special about `HelloCmp`, which is a regular Angular component. It can also be
   * used in other static
   * locations.
   *
   * ```
   * @Component({
   *   selector: 'dynamic-comp'
   * })
   * class DynamicComp {
   *   helloCmp:HelloCmp;
   *   constructor(loader:DynamicComponentLoader, location:ElementRef) {
   *     loader.load(HelloCmp, location).then((helloCmp) => {
   *       this.helloCmp = helloCmp;
   *     });
   *   }
   * }
   *
   * @Component({
   *   selector: 'hello-cmp'
   * })
   * @View({
   *   template: "{{greeting}}"
   * })
   * class HelloCmp {
   *   greeting:string;
   *   constructor() {
   *     this.greeting = "hello";
   *   }
   * }
   * ```
   */
  function Component(arg: _ComponentArg): (target: any) => any;  
  interface _ComponentArg {
    /**
     * Defines the used change detection strategy.
     *
     * When a component is instantiated, Angular creates a change detector, which is responsible for
     * propagating
     * the component's bindings.
     *
     * The `changeDetection` property defines, whether the change detection will be checked every time
     * or only when the component
     * tells it to do so.
     */
    changeDetection?: string;
  
    /**
     * Defines the set of injectable objects that are visible to a Component and its children.
     *
     * The `appInjector` defined in the Component annotation allow you to configure a set of bindings
     * for the component's
     * injector.
     *
     * When a component is instantiated, Angular creates a new child Injector, which is configured
     * with the bindings in
     * the Component `appInjector` annotation. The injectable objects then become available for
     * injection to the component
     * itself and any of the directives in the component's template, i.e. they are not available to
     * the directives which
     * are children in the component's light DOM.
     *
     *
     * The syntax for configuring the `appInjector` injectable is identical to {@link Injector}
     * injectable configuration.
     * See {@link Injector} for additional detail.
     *
     *
     * ## Simple Example
     *
     * Here is an example of a class that can be injected:
     *
     * ```
     * class Greeter {
     *    greet(name:string) {
     *      return 'Hello ' + name + '!';
     *    }
     * }
     *
     * @Component({
     *   selector: 'greet',
     *   appInjector: [
     *     Greeter
     *   ]
     * })
     * @View({
     *   template: `{{greeter.greet('world')}}!`,
     *   directives: [Child]
     * })
     * class HelloWorld {
     *   greeter:Greeter;
     *
     *   constructor(greeter:Greeter) {
     *     this.greeter = greeter;
     *   }
     * }
     * ```
     */
    appInjector?: List<any>;
  
    /**
     * Defines the set of injectable objects that are visible to its view dom children.
     *
     * ## Simple Example
     *
     * Here is an example of a class that can be injected:
     *
     * ```
     * class Greeter {
     *    greet(name:string) {
     *      return 'Hello ' + name + '!';
     *    }
     * }
     *
     * @Directive({
     *   selector: 'needs-greeter'
     * })
     * class NeedsGreeter {
     *   greeter:Greeter;
     *
     *   constructor(greeter:Greeter) {
     *     this.greeter = greeter;
     *   }
     * }
     *
     * @Component({
     *   selector: 'greet',
     *   viewInjector: [
     *     Greeter
     *   ]
     * })
     * @View({
     *   template: `<needs-greeter></needs-greeter>`,
     *   directives: [NeedsGreeter]
     * })
     * class HelloWorld {
     * }
     *
     * ```
     */
    viewInjector?: List<any>;
    
    selector?: string;
    properties?: List<string>;
    events?: List<string>;
    hostListeners?: StringMap<string, string>;
    hostProperties?: StringMap<string, string>;
    hostAttributes?: StringMap<string, string>;
    hostActions?: StringMap<string, string>;
    exportAs?: string;
    lifecycle?: List<LifecycleEvent>;
    hostInjector?: List<any>;
    compileChildren?: boolean;
  }
  
  class ComponentAnnotation extends  DirectiveAnnotation {
  }
  
  /**
   * Directives allow you to attach behavior to elements in the DOM.
   * 
   * <a href='/angular2/angular2/Directive'><code>Directive</code></a>s with an embedded view are called <a href='/angular2/angular2/Component'><code>Component</code></a>s.
   * 
   * A directive consists of a single directive annotation and a controller class. When the
   * directive's `selector` matches
   * elements in the DOM, the following steps occur:
   * 
   * 1. For each directive, the `ElementInjector` attempts to resolve the directive's constructor
   * arguments.
   * 2. Angular instantiates directives for each matched element using `ElementInjector` in a
   * depth-first order,
   *    as declared in the HTML.
   * 
   * ## Understanding How Injection Works
   * 
   * There are three stages of injection resolution.
   * - *Pre-existing Injectors*:
   *   - The terminal <a href='/angular2/angular2/Injector'><code>Injector</code></a> cannot resolve dependencies. It either throws an error or, if
   * the dependency was
   *     specified as `@Optional`, returns `null`.
   *   - The platform injector resolves browser singleton resources, such as: cookies, title,
   * location, and others.
   * - *Component Injectors*: Each component instance has its own <a href='/angular2/angular2/Injector'><code>Injector</code></a>, and they follow
   * the same parent-child hierarchy
   *     as the component instances in the DOM.
   * - *Element Injectors*: Each component instance has a Shadow DOM. Within the Shadow DOM each
   * element has an `ElementInjector`
   *     which follow the same parent-child hierarchy as the DOM elements themselves.
   * 
   * When a template is instantiated, it also must instantiate the corresponding directives in a
   * depth-first order. The
   * current `ElementInjector` resolves the constructor dependencies for each directive.
   * 
   * Angular then resolves dependencies as follows, according to the order in which they appear in the
   * <a href='/angular2/angular2/View'><code>View</code></a>:
   * 
   * 1. Dependencies on the current element
   * 2. Dependencies on element injectors and their parents until it encounters a Shadow DOM boundary
   * 3. Dependencies on component injectors and their parents until it encounters the root component
   * 4. Dependencies on pre-existing injectors
   * 
   * 
   * The `ElementInjector` can inject other directives, element-specific special objects, or it can
   * delegate to the parent
   * injector.
   * 
   * To inject other directives, declare the constructor parameter as:
   * - `directive:DirectiveType`: a directive on the current element only
   * - `@Ancestor() directive:DirectiveType`: any directive that matches the type between the current
   * element and the
   *    Shadow DOM root. Current element is not included in the resolution, therefore even if it could
   * resolve it, it will
   *    be ignored.
   * - `@Parent() directive:DirectiveType`: any directive that matches the type on a direct parent
   * element only.
   * - `@Query(DirectiveType) query:QueryList<DirectiveType>`: A live collection of direct child
   * directives.
   * - `@QueryDescendants(DirectiveType) query:QueryList<DirectiveType>`: A live collection of any
   * child directives.
   * 
   * To inject element-specific special objects, declare the constructor parameter as:
   * - `element: ElementRef` to obtain a reference to logical element in the view.
   * - `viewContainer: ViewContainerRef` to control child template instantiation, for
   * <a href='/angular2/angular2/Directive'><code>Directive</code></a> directives only
   * - `bindingPropagation: BindingPropagation` to control change detection in a more granular way.
   * 
   * ## Example
   * 
   * The following example demonstrates how dependency injection resolves constructor arguments in
   * practice.
   * 
   * 
   * Assume this HTML template:
   * 
   * ```
   * <div dependency="1">
   *   <div dependency="2">
   *     <div dependency="3" my-directive>
   *       <div dependency="4">
   *         <div dependency="5"></div>
   *       </div>
   *       <div dependency="6"></div>
   *     </div>
   *   </div>
   * </div>
   * ```
   * 
   * With the following `dependency` decorator and `SomeService` injectable class.
   * 
   * ```
   * @Injectable()
   * class SomeService {
   * }
   * 
   * @Directive({
   *   selector: '[dependency]',
   *   properties: [
   *     'id: dependency'
   *   ]
   * })
   * class Dependency {
   *   id:string;
   * }
   * ```
   * 
   * Let's step through the different ways in which `MyDirective` could be declared...
   * 
   * 
   * ### No injection
   * 
   * Here the constructor is declared with no arguments, therefore nothing is injected into
   * `MyDirective`.
   * 
   * ```
   * @Directive({ selector: '[my-directive]' })
   * class MyDirective {
   *   constructor() {
   *   }
   * }
   * ```
   * 
   * This directive would be instantiated with no dependencies.
   * 
   * 
   * ### Component-level injection
   * 
   * Directives can inject any injectable instance from the closest component injector or any of its
   * parents.
   * 
   * Here, the constructor declares a parameter, `someService`, and injects the `SomeService` type
   * from the parent
   * component's injector.
   * ```
   * @Directive({ selector: '[my-directive]' })
   * class MyDirective {
   *   constructor(someService: SomeService) {
   *   }
   * }
   * ```
   * 
   * This directive would be instantiated with a dependency on `SomeService`.
   * 
   * 
   * ### Injecting a directive from the current element
   * 
   * Directives can inject other directives declared on the current element.
   * 
   * ```
   * @Directive({ selector: '[my-directive]' })
   * class MyDirective {
   *   constructor(dependency: Dependency) {
   *     expect(dependency.id).toEqual(3);
   *   }
   * }
   * ```
   * This directive would be instantiated with `Dependency` declared at the same element, in this case
   * `dependency="3"`.
   * 
   * 
   * ### Injecting a directive from a direct parent element
   * 
   * Directives can inject other directives declared on a direct parent element. By definition, a
   * directive with a
   * `@Parent` annotation does not attempt to resolve dependencies for the current element, even if
   * this would satisfy
   * the dependency.
   * 
   * ```
   * @Directive({ selector: '[my-directive]' })
   * class MyDirective {
   *   constructor(@Parent() dependency: Dependency) {
   *     expect(dependency.id).toEqual(2);
   *   }
   * }
   * ```
   * This directive would be instantiated with `Dependency` declared at the parent element, in this
   * case `dependency="2"`.
   * 
   * 
   * ### Injecting a directive from any ancestor elements
   * 
   * Directives can inject other directives declared on any ancestor element (in the current Shadow
   * DOM), i.e. on the
   * parent element and its parents. By definition, a directive with an `@Ancestor` annotation does
   * not attempt to
   * resolve dependencies for the current element, even if this would satisfy the dependency.
   * 
   * ```
   * @Directive({ selector: '[my-directive]' })
   * class MyDirective {
   *   constructor(@Ancestor() dependency: Dependency) {
   *     expect(dependency.id).toEqual(2);
   *   }
   * }
   * ```
   * 
   * Unlike the `@Parent` which only checks the parent, `@Ancestor` checks the parent, as well as its
   * parents recursively. If `dependency="2"` didn't exist on the direct parent, this injection would
   * have returned
   * `dependency="1"`.
   * 
   * 
   * ### Injecting a live collection of direct child directives
   * 
   * 
   * A directive can also query for other child directives. Since parent directives are instantiated
   * before child directives, a directive can't simply inject the list of child directives. Instead,
   * the directive injects a <a href='QueryList'>QueryList</a>, which updates its contents as children are added,
   * removed, or moved by a directive that uses a <a href='/angular2/angular2/ViewContainerRef'><code>ViewContainerRef</code></a> such as a `ng-for`, an
   * `ng-if`, or an `ng-switch`.
   * 
   * ```
   * @Directive({ selector: '[my-directive]' })
   * class MyDirective {
   *   constructor(@Query(Dependency) dependencies:QueryList<Dependency>) {
   *   }
   * }
   * ```
   * 
   * This directive would be instantiated with a <a href='QueryList'>QueryList</a> which contains `Dependency` 4 and
   * 6. Here, `Dependency` 5 would not be included, because it is not a direct child.
   * 
   * ### Injecting a live collection of descendant directives
   * 
   * Note: This is will be implemented in later release. ()
   * 
   * Similar to `@Query` above, but also includes the children of the child elements.
   * 
   * ```
   * @Directive({ selector: '[my-directive]' })
   * class MyDirective {
   *   constructor(@QueryDescendents(Dependency) dependencies:QueryList<Dependency>) {
   *   }
   * }
   * ```
   * 
   * This directive would be instantiated with a Query which would contain `Dependency` 4, 5 and 6.
   * 
   * ### Optional injection
   * 
   * The normal behavior of directives is to return an error when a specified dependency cannot be
   * resolved. If you
   * would like to inject `null` on unresolved dependency instead, you can annotate that dependency
   * with `@Optional()`.
   * This explicitly permits the author of a template to treat some of the surrounding directives as
   * optional.
   * 
   * ```
   * @Directive({ selector: '[my-directive]' })
   * class MyDirective {
   *   constructor(@Optional() dependency:Dependency) {
   *   }
   * }
   * ```
   * 
   * This directive would be instantiated with a `Dependency` directive found on the current element.
   * If none can be
   * found, the injector supplies `null` instead of throwing an error.
   * 
   * ## Example
   * 
   * Here we use a decorator directive to simply define basic tool-tip behavior.
   * 
   * ```
   * @Directive({
   *   selector: '[tooltip]',
   *   properties: [
   *     'text: tooltip'
   *   ],
   *   hostListeners: {
   *     'onmouseenter': 'onMouseEnter()',
   *     'onmouseleave': 'onMouseLeave()'
   *   }
   * })
   * class Tooltip{
   *   text:string;
   *   overlay:Overlay; // NOT YET IMPLEMENTED
   *   overlayManager:OverlayManager; // NOT YET IMPLEMENTED
   * 
   *   constructor(overlayManager:OverlayManager) {
   *     this.overlay = overlay;
   *   }
   * 
   *   onMouseEnter() {
   *     // exact signature to be determined
   *     this.overlay = this.overlayManager.open(text, ...);
   *   }
   * 
   *   onMouseLeave() {
   *     this.overlay.close();
   *     this.overlay = null;
   *   }
   * }
   * ```
   * In our HTML template, we can then add this behavior to a `<div>` or any other element with the
   * `tooltip` selector,
   * like so:
   * 
   * ```
   * <div tooltip="some text here"></div>
   * ```
   * 
   * Directives can also control the instantiation, destruction, and positioning of inline template
   * elements:
   * 
   * A directive uses a <a href='/angular2/angular2/ViewContainerRef'><code>ViewContainerRef</code></a> to instantiate, insert, move, and destroy views at
   * runtime.
   * The <a href='/angular2/angular2/ViewContainerRef'><code>ViewContainerRef</code></a> is created as a result of `<template>` element, and represents a
   * location in the current view
   * where these actions are performed.
   * 
   * Views are always created as children of the current <a href='/angular2/angular2/View'><code>View</code></a>, and as siblings of the
   * `<template>` element. Thus a
   * directive in a child view cannot inject the directive that created it.
   * 
   * Since directives that create views via ViewContainers are common in Angular, and using the full
   * `<template>` element syntax is wordy, Angular
   * also supports a shorthand notation: `<li *foo="bar">` and `<li template="foo: bar">` are
   * equivalent.
   * 
   * Thus,
   * 
   * ```
   * <ul>
   *   <li *foo="bar" title="text"></li>
   * </ul>
   * ```
   * 
   * Expands in use to:
   * 
   * ```
   * <ul>
   *   <template [foo]="bar">
   *     <li title="text"></li>
   *   </template>
   * </ul>
   * ```
   * 
   * Notice that although the shorthand places `*foo="bar"` within the `<li>` element, the binding for
   * the directive
   * controller is correctly instantiated on the `<template>` element rather than the `<li>` element.
   * 
   * 
   * ## Example
   * 
   * Let's suppose we want to implement the `unless` behavior, to conditionally include a template.
   * 
   * Here is a simple directive that triggers on an `unless` selector:
   * 
   * ```
   * @Directive({
   *   selector: '[unless]',
   *   properties: ['unless']
   * })
   * export class Unless {
   *   viewContainer: ViewContainerRef;
   *   protoViewRef: ProtoViewRef;
   *   prevCondition: boolean;
   * 
   *   constructor(viewContainer: ViewContainerRef, protoViewRef: ProtoViewRef) {
   *     this.viewContainer = viewContainer;
   *     this.protoViewRef = protoViewRef;
   *     this.prevCondition = null;
   *   }
   * 
   *   set unless(newCondition) {
   *     if (newCondition && (isBlank(this.prevCondition) || !this.prevCondition)) {
   *       this.prevCondition = true;
   *       this.viewContainer.clear();
   *     } else if (!newCondition && (isBlank(this.prevCondition) || this.prevCondition)) {
   *       this.prevCondition = false;
   *       this.viewContainer.create(this.protoViewRef);
   *     }
   *   }
   * }
   * ```
   * 
   * We can then use this `unless` selector in a template:
   * ```
   * <ul>
   *   <li *unless="expr"></li>
   * </ul>
   * ```
   * 
   * Once the directive instantiates the child view, the shorthand notation for the template expands
   * and the result is:
   * 
   * ```
   * <ul>
   *   <template [unless]="exp">
   *     <li></li>
   *   </template>
   *   <li></li>
   * </ul>
   * ```
   * 
   * Note also that although the `<li></li>` template still exists inside the `<template></template>`,
   * the instantiated
   * view occurs on the second `<li></li>` which is a sibling to the `<template>` element.
   * 
   * @exportedAs angular2/annotations
   */
  function Directive(arg: _DirectiveArg): (target: any) => any;
  interface _DirectiveArg {

    /**
     * If set to true the compiler does not compile the children of this directive.
     */
    compileChildren?: boolean;

    /**
     * Enumerates the set of emitted events.
     * 
     * ## Syntax
     * 
     * ```
     * @Component({
     *   events: ['statusChange']
     * })
     * class TaskComponent {
     *   statusChange:EventEmitter;
     * 
     *   constructor() {
     *     this.statusChange = new EventEmitter();
     *   }
     * 
     *   onComplete() {
     *     this.statusChange.next('completed');
     *   }
     * }
     * ```
     */
    events?: List<string>;

    /**
     * Specifies which DOM methods a directive can invoke.
     * 
     * ## Syntax
     * 
     * ```
     * @Directive({
     *   selector: 'input',
     *   hostActions: {
     *     'emitFocus': 'focus()'
     *   }
     * })
     * class InputDirective {
     *   constructor() {
     *     this.emitFocus = new EventEmitter();
     *   }
     * 
     *   focus() {
     *     this.emitFocus.next();
     *   }
     * }
     * 
     * In this example calling focus on InputDirective will result in calling focus on the DOM
     * element.
     * ```
     */
    hostActions?: StringMap<string, string>;

    /**
     * Specifies static attributes that should be propagated to a host element. Attributes specified
     * in `hostAttributes`
     * are propagated only if a given attribute is not present on a host element.
     * 
     * ## Syntax
     * 
     * ```
     * @Directive({
     *   selector: '[my-button]',
     *   hostAttributes: {
     *     'role': 'button'
     *   }
     * })
     * class MyButton {
     * }
     * 
     * In this example using `my-button` directive (ex.: `<div my-button></div>`) on a host element
     * (here: `<div>` )
     * will ensure that this element will get the "button" role.
     * ```
     */
    hostAttributes?: StringMap<string, string>;

    /**
     * Defines the set of injectable objects that are visible to a Directive and its light dom
     * children.
     * 
     * ## Simple Example
     * 
     * Here is an example of a class that can be injected:
     * 
     * ```
     * class Greeter {
     *    greet(name:string) {
     *      return 'Hello ' + name + '!';
     *    }
     * }
     * 
     * @Directive({
     *   selector: 'greet',
     *   hostInjector: [
     *     Greeter
     *   ]
     * })
     * class HelloWorld {
     *   greeter:Greeter;
     * 
     *   constructor(greeter:Greeter) {
     *     this.greeter = greeter;
     *   }
     * }
     * ```
     */
    hostInjector?: List<any>;

    /**
     * Specifies which DOM hostListeners a directive listens to.
     * 
     * The `hostListeners` property defines a set of `event` to `method` key-value pairs:
     * 
     * - `event1`: the DOM event that the directive listens to.
     * - `statement`: the statement to execute when the event occurs.
     * If the evalutation of the statement returns `false`, then `preventDefault`is applied on the DOM
     * event.
     * 
     * To listen to global events, a target must be added to the event name.
     * The target can be `window`, `document` or `body`.
     * 
     * When writing a directive event binding, you can also refer to the following local variables:
     * - `$event`: Current event object which triggered the event.
     * - `$target`: The source of the event. This will be either a DOM element or an Angular
     * directive.
     *   (will be implemented in later release)
     * 
     * 
     * ## Syntax
     * 
     * ```
     * @Directive({
     *   hostListeners: {
     *     'event1': 'onMethod1(arguments)',
     *     'target:event2': 'onMethod2(arguments)',
     *     ...
     *   }
     * }
     * ```
     * 
     * ## Basic Event Binding:
     * 
     * Suppose you want to write a directive that triggers on `change` events in the DOM and on
     * `resize` events in window.
     * You would define the event binding as follows:
     * 
     * ```
     * @Directive({
     *   selector: 'input',
     *   hostListeners: {
     *     'change': 'onChange($event)',
     *     'window:resize': 'onResize($event)'
     *   }
     * })
     * class InputDirective {
     *   onChange(event:Event) {
     *   }
     *   onResize(event:Event) {
     *   }
     * }
     * ```
     * 
     * Here the `onChange` method of `InputDirective` is invoked whenever the DOM element fires the
     * 'change' event.
     */
    hostListeners?: StringMap<string, string>;

    /**
     * Specifies which DOM properties a directives updates.
     * 
     * ## Syntax
     * 
     * ```
     * @Directive({
     *   selector: 'input',
     *   hostProperties: {
     *     'value': 'value'
     *   }
     * })
     * class InputDirective {
     *   value:string;
     * }
     * 
     * In this example every time the value property of the decorator changes, Angular will update the
     * value property of
     * the host element.
     * ```
     */
    hostProperties?: StringMap<string, string>;

    /**
     * Specifies a set of lifecycle hostListeners in which the directive participates.
     * 
     * See <a href='annotations/onChange'>onChange</a>, <a href='annotations/onDestroy'>onDestroy</a>,
     * <a href='annotations/onAllChangesDone'>onAllChangesDone</a> for details.
     */
    lifecycle?: List<LifecycleEvent>;

    /**
     * Enumerates the set of properties that accept data binding for a directive.
     * 
     * The `properties` property defines a set of `directiveProperty` to `bindingProperty`
     * configuration:
     * 
     * - `directiveProperty` specifies the component property where the value is written.
     * - `bindingProperty` specifies the DOM property where the value is read from.
     * 
     * You can include a <a href='/angular2/angular2/Pipe'><code>Pipe</code></a> when specifying a `bindingProperty` to allow for data
     * transformation and structural change detection of the value. These pipes will be evaluated in
     * the context of this component.
     * 
     * ## Syntax
     * 
     * There is no need to specify both `directiveProperty` and `bindingProperty` when they both have
     * the same value.
     * 
     * ```
     * @Directive({
     *   properties: [
     *     'propertyName', // shorthand notation for 'propertyName: propertyName'
     *     'directiveProperty1: bindingProperty1',
     *     'directiveProperty2: bindingProperty2 | pipe1 | ...',
     *     ...
     *   ]
     * }
     * ```
     * 
     * 
     * ## Basic Property Binding
     * 
     * We can easily build a simple `Tooltip` directive that exposes a `tooltip` property, which can
     * be used in templates with standard Angular syntax. For example:
     * 
     * ```
     * @Directive({
     *   selector: '[tooltip]',
     *   properties: [
     *     'text: tooltip'
     *   ]
     * })
     * class Tooltip {
     *   set text(value: string) {
     *     // This will get called every time with the new value when the 'tooltip' property changes
     *   }
     * }
     * ```
     * 
     * We can then bind to the `tooltip' property as either an expression (`someExpression`) or as a
     * string literal, as shown in the HTML template below:
     * 
     * ```html
     * <div [tooltip]="someExpression">...</div>
     * <div tooltip="Some Text">...</div>
     * ```
     * 
     * Whenever the `someExpression` expression changes, the `properties` declaration instructs
     * Angular to update the `Tooltip`'s `text` property.
     * 
     * ## Bindings With Pipes
     * 
     * You can also use pipes when writing binding definitions for a directive.
     * 
     * For example, we could write a binding that updates the directive on structural changes, rather
     * than on reference changes, as normally occurs in change detection.
     * 
     * See <a href='/angular2/angular2/Pipe'><code>Pipe</code></a> and <a href='pipes/keyValDiff'>keyValDiff</a> documentation for more details.
     * 
     * ```
     * @Directive({
     *   selector: '[class-set]',
     *   properties: [
     *     'classChanges: classSet | keyValDiff'
     *   ]
     * })
     * class ClassSet {
     *   set classChanges(changes: KeyValueChanges) {
     *     // This will get called every time the `class-set` expressions changes its structure.
     *   }
     * }
     * ```
     * 
     * The template that this directive is used in may also contain its own pipes. For example:
     * 
     * ```html
     * <div [class-set]="someExpression | somePipe">
     * ```
     * 
     * In this case, the two pipes compose as if they were inlined: `someExpression | somePipe |
     * keyValDiff`.
     */
    properties?: List<string>;

    /**
     * The CSS selector that triggers the instantiation of a directive.
     * 
     * Angular only allows directives to trigger on CSS selectors that do not cross element
     * boundaries.
     * 
     * `selector` may be declared as one of the following:
     * 
     * - `element-name`: select by element name.
     * - `.class`: select by class name.
     * - `[attribute]`: select by attribute name.
     * - `[attribute=value]`: select by attribute name and value.
     * - `:not(sub_selector)`: select only if the element does not match the `sub_selector`.
     * - `selector1, selector2`: select if either `selector1` or `selector2` matches.
     * 
     * 
     * ## Example
     * 
     * Suppose we have a directive with an `input[type=text]` selector.
     * 
     * And the following HTML:
     * 
     * ```html
     * <form>
     *   <input type="text">
     *   <input type="radio">
     * <form>
     * ```
     * 
     * The directive would only be instantiated on the `<input type="text">` element.
     */
    selector?: string;
  }
  
  class DirectiveAnnotation extends  Injectable {

  }
  

  /**
   * Notify a directive whenever a <a href='/angular2/angular2/View'><code>View</code></a> that contains it is destroyed.
   * 
   * ## Example
   * 
   * ```
   * @Directive({
   *   ...,
   *   lifecycle: [onDestroy]
   * })
   * class ClassSet {
   *   onDestroy() {
   *     // invoked to notify directive of the containing view destruction.
   *   }
   * }
   * ```
   * @exportedAs angular2/annotations
   */
  var onDestroy: any;
  

  /**
   * Notify a directive when any of its bindings have changed.
   * 
   * This method is called right after the directive's bindings have been checked,
   * and before any of its children's bindings have been checked.
   * 
   * It is invoked only if at least one of the directive's bindings has changed.
   * 
   * ## Example:
   * 
   * ```
   * @Directive({
   *   selector: '[class-set]',
   *   properties: [
   *     'propA',
   *     'propB'
   *   ],
   *   lifecycle: [onChange]
   * })
   * class ClassSet {
   *   propA;
   *   propB;
   *   onChange(changes:{[idx: string, PropertyUpdate]}) {
   *     // This will get called after any of the properties have been updated.
   *     if (changes['propA']) {
   *       // if propA was updated
   *     }
   *     if (changes['propA']) {
   *       // if propB was updated
   *     }
   *   }
   * }
   *  ```
   * @exportedAs angular2/annotations
   */
  var onChange: any;
  

  /**
   * Notify a directive when it has been checked.
   * 
   * This method is called right after the directive's bindings have been checked,
   * and before any of its children's bindings have been checked.
   * 
   * It is invoked every time even when none of the directive's bindings has changed.
   * 
   * ## Example:
   * 
   * ```
   * @Directive({
   *   selector: '[class-set]',
   *   lifecycle: [onCheck]
   * })
   * class ClassSet {
   *   onCheck() {
   *   }
   * }
   *  ```
   * @exportedAs angular2/annotations
   */
  var onCheck: any;
  

  /**
   * Notify a directive when it has been checked the first itme.
   * 
   * This method is called right after the directive's bindings have been checked,
   * and before any of its children's bindings have been checked.
   * 
   * It is invoked only once.
   * 
   * ## Example:
   * 
   * ```
   * @Directive({
   *   selector: '[class-set]',
   *   lifecycle: [onInit]
   * })
   * class ClassSet {
   *   onInit() {
   *   }
   * }
   *  ```
   * @exportedAs angular2/annotations
   */
  var onInit: any;
  

  /**
   * Notify a directive when the bindings of all its children have been changed.
   * 
   * ## Example:
   * 
   * ```
   * @Directive({
   *   selector: '[class-set]',
   *   lifecycle: [onAllChangesDone]
   * })
   * class ClassSet {
   * 
   *   onAllChangesDone() {
   *   }
   * 
   * }
   *  ```
   * @exportedAs angular2/annotations
   */
  var onAllChangesDone: any;

  var Self: any;
  
  var Parent: any;
  
  var Ancestor: any;
  
  var Unbounded: any;
  
  var Attribute: any;
  
  var Query: any;
  

  /**
   * A collection of the Angular core directives that are likely to be used in each and every Angular
   * application.
   * 
   * This collection can be used to quickly enumerate all the built-in directives in the `@View`
   * annotation. For example,
   * instead of writing:
   * 
   * ```
   * import {If, NgFor, NgSwitch, NgSwitchWhen, NgSwitchDefault} from 'angular2/angular2';
   * import {OtherDirective} from 'myDirectives';
   * 
   * @Component({
   *  selector: 'my-component'
   * })
   * @View({
   *   templateUrl: 'myComponent.html',
   *   directives: [If, NgFor, NgSwitch, NgSwitchWhen, NgSwitchDefault, OtherDirective]
   * })
   * export class MyComponent {
   *   ...
   * }
   * ```
   * one could enumerate all the core directives at once:
   * 
   * ```
   * import {coreDirectives} from 'angular2/angular2';
   * import {OtherDirective} from 'myDirectives';
   * 
   * @Component({
   *  selector: 'my-component'
   * })
   * @View({
   *   templateUrl: 'myComponent.html',
   *   directives: [coreDirectives, OtherDirective]
   * })
   * export class MyComponent {
   *   ...
   * }
   * ```
   */
  var coreDirectives : List<Type> ;
  
  class CSSClass {
    iterableChanges: any;
  }
  

  /**
   * The `NgFor` directive instantiates a template once per item from an iterable. The context for
   * each instantiated template inherits from the outer context with the given loop variable set
   * to the current item from the iterable.
   * 
   * It is possible to alias the `index` to a local variable that will be set to the current loop
   * iteration in the template context.
   * 
   * When the contents of the iterator changes, `NgFor` makes the corresponding changes to the DOM:
   * 
   * * When an item is added, a new instance of the template is added to the DOM.
   * * When an item is removed, its template instance is removed from the DOM.
   * * When items are reordered, their respective templates are reordered in the DOM.
   * 
   * # Example
   * 
   * ```
   * <ul>
   *   <li *ng-for="#error of errors; #i = index">
   *     Error {{i}} of {{errors.length}}: {{error.message}}
   *   </li>
   * </ul>
   * ```
   * 
   * # Syntax
   * 
   * - `<li *ng-for="#item of items; #i = index">...</li>`
   * - `<li template="ng-for #item of items; #i = index">...</li>`
   * - `<template [ng-for] #item [ng-for-of]="items" #i="index"><li>...</li></template>`
   * 
   * @exportedAs angular2/directives
   */
  class NgFor {
    iterableChanges: any;
    perViewChange(view: any, record: any): any;
    protoViewRef: ProtoViewRef;
    viewContainer: ViewContainerRef;
  }
  

  /**
   * Removes or recreates a portion of the DOM tree based on an {expression}.
   * 
   * If the expression assigned to `ng-if` evaluates to a false value then the element
   * is removed from the DOM, otherwise a clone of the element is reinserted into the DOM.
   * 
   * # Example:
   * 
   * ```
   * <div *ng-if="errorCount > 0" class="error">
   *   <!-- Error message displayed when the errorCount property on the current context is greater
   * than 0. -->
   *   {{errorCount}} errors detected
   * </div>
   * ```
   * 
   * # Syntax
   * 
   * - `<div *ng-if="condition">...</div>`
   * - `<div template="ng-if condition">...</div>`
   * - `<template [ng-if]="condition"><div>...</div></template>`
   * 
   * @exportedAs angular2/directives
   */
  class NgIf {
    ngIf: any;
    prevCondition: boolean;
    protoViewRef: ProtoViewRef;
    viewContainer: ViewContainerRef;
  }
  

  /**
   * The `NgNonBindable` directive tells Angular not to compile or bind the contents of the current
   * DOM element. This is useful if the element contains what appears to be Angular directives and
   * bindings but which should be ignored by Angular. This could be the case if you have a site that
   * displays snippets of code, for instance.
   * 
   * Example:
   * 
   * ```
   * <div>Normal: {{1 + 2}}</div> // output "Normal: 3"
   * <div non-bindable>Ignored: {{1 + 2}}</div> // output "Ignored: {{1 + 2}}"
   * ```
   * 
   * @exportedAs angular2/directives
   */
  class NgNonBindable {
  }
  
  class SwitchView {
    create(): any;
    destroy(): any;
  }
  

  /**
   * The `NgSwitch` directive is used to conditionally swap DOM structure on your template based on a
   * scope expression.
   * Elements within `NgSwitch` but without `NgSwitchWhen` or `NgSwitchDefault` directives will be
   * preserved at the location as specified in the template.
   * 
   * `NgSwitch` simply chooses nested elements and makes them visible based on which element matches
   * the value obtained from the evaluated expression. In other words, you define a container element
   * (where you place the directive), place an expression on the **`[ng-switch]="..."` attribute**),
   * define any inner elements inside of the directive and place a `[ng-switch-when]` attribute per
   * element.
   * The when attribute is used to inform NgSwitch which element to display when the expression is
   * evaluated. If a matching expression is not found via a when attribute then an element with the
   * default attribute is displayed.
   * 
   * # Example:
   * 
   * ```
   * <ANY [ng-switch]="expression">
   *   <template [ng-switch-when]="whenExpression1">...</template>
   *   <template [ng-switch-when]="whenExpression1">...</template>
   *   <template [ng-switch-default]>...</template>
   * </ANY>
   * ```
   * 
   * @exportedAs angular2/directives
   */
  class NgSwitch {
    ngSwitch: any;
  }
  

  /**
   * Defines a case statement as an expression.
   * 
   * If multiple `NgSwitchWhen` match the `NgSwitch` value, all of them are displayed.
   * 
   * Example:
   * 
   * ```
   * // match against a context variable
   * <template [ng-switch-when]="contextVariable">...</template>
   * 
   * // match against a constant string
   * <template [ng-switch-when]="'stringValue'">...</template>
   * ```
   * 
   * @exportedAs angular2/directives
   */
  class NgSwitchWhen {
    ngSwitchWhen: any;
    onDestroy(): any;
  }
  

  /**
   * Defines a default case statement.
   * 
   * Default case statements are displayed when no `NgSwitchWhen` match the `ng-switch` value.
   * 
   * Example:
   * 
   * ```
   * <template [ng-switch-default]>...</template>
   * ```
   * 
   * @exportedAs angular2/directives
   */
  class NgSwitchDefault {
  }
  

  /**
   * Indicates that a Control is valid, i.e. that no errors exist in the input value.
   * 
   * @exportedAs angular2/forms
   */
  var VALID: any;
  

  /**
   * Indicates that a Control is invalid, i.e. that an error exists in the input value.
   * 
   * @exportedAs angular2/forms
   */
  var INVALID: any;
  
  function isControl(c: Object) : boolean ;
  
  interface _AbstractControl_onlySelf {
    onlySelf?: boolean;
  }
  interface _AbstractControl_updateValueAndValidity {
    onlySelf?: boolean;
    emitEvent?: boolean;
  }

  /**
   * Omitting from external API doc as this is really an abstract internal concept.
   */
  class AbstractControl {
    dirty: boolean;
    errors: StringMap<string, any>;
    markAsDirty(arg?: _AbstractControl_onlySelf): void;
    markAsTouched(): void;
    pristine: boolean;
    setParent(parent: any): any;
    status: string;
    touched: boolean;
    untouched: boolean;
    updateValidity(arg?: _AbstractControl_onlySelf): void;
    updateValueAndValidity(arg?: _AbstractControl_updateValueAndValidity): void;
    valid: boolean;
    validator: Function;
    value: any;
    valueChanges: Observable;
  }
  
  interface _Control_updateValue {
    onlySelf?: boolean;
    emitEvent?: boolean
  }

  /**
   * Defines a part of a form that cannot be divided into other controls.
   * 
   * `Control` is one of the three fundamental building blocks used to define forms in Angular, along
   * with
   * <a href='ControlGroup'>ControlGroup</a> and <a href='ControlArray'>ControlArray</a>.
   * 
   * @exportedAs angular2/forms
   */
  class Control extends  AbstractControl {
    registerOnChange(fn: Function): void;
    updateValue(value: any, arg?: _Control_updateValue): void;
  }
  

  /**
   * Defines a part of a form, of fixed length, that can contain other controls.
   * 
   * A ControlGroup aggregates the values and errors of each <a href='Control'>Control</a> in the group. Thus, if
   * one of the controls
   * in a group is invalid, the entire group is invalid. Similarly, if a control changes its value,
   * the entire group
   * changes as well.
   * 
   * `ControlGroup` is one of the three fundamental building blocks used to define forms in Angular,
   * along with
   * <a href='Control'>Control</a> and <a href='ControlArray'>ControlArray</a>. <a href='ControlArray'>ControlArray</a> can also contain other controls,
   * but is of variable
   * length.
   * 
   * @exportedAs angular2/forms
   */
  class ControlGroup extends  AbstractControl {
    addControl(name: string, c: AbstractControl): any;
    contains(controlName: string): boolean;
    controls: StringMap<string, AbstractControl>;
    exclude(controlName: string): void;
    find(path: string | List<string>): AbstractControl;
    include(controlName: string): void;
    removeControl(name: string): any;
  }
  

  /**
   * Defines a part of a form, of variable length, that can contain other controls.
   * 
   * A `ControlArray` aggregates the values and errors of each <a href='Control'>Control</a> in the group. Thus, if
   * one of the controls
   * in a group is invalid, the entire group is invalid. Similarly, if a control changes its value,
   * the entire group
   * changes as well.
   * 
   * `ControlArray` is one of the three fundamental building blocks used to define forms in Angular,
   * along with
   * <a href='Control'>Control</a> and <a href='ControlGroup'>ControlGroup</a>. <a href='ControlGroup'>ControlGroup</a> can also contain other controls,
   * but is of fixed
   * length.
   * 
   * @exportedAs angular2/forms
   */
  class ControlArray extends  AbstractControl {
    at(index: number): AbstractControl;
    controls: List<AbstractControl>;
    insert(index: number, control: AbstractControl): void;
    length: number;
    push(control: AbstractControl): void;
    removeAt(index: number): void;
  }
  

  /**
   * Binds a control with the specified name to a DOM element.
   * 
   * # Example
   * 
   * In this example, we bind the login control to an input element. When the value of the input
   * element
   * changes, the value of
   * the control will reflect that change. Likewise, if the value of the control changes, the input
   * element reflects that
   * change.
   * 
   * Here we use <a href='/angular2/angular2/formDirectives'><code>formDirectives</code></a>, rather than importing each form directive individually, e.g.
   * `ControlDirective`, `ControlGroupDirective`. This is just a shorthand for the same end result.
   * 
   *  ```
   * @Component({selector: "login-comp"})
   * @View({
   *      directives: [formDirectives],
   *      template:
   *              "<form [ng-form-model]='loginForm'>" +
   *              "Login <input type='text' ng-control='login'>" +
   *              "<button (click)="onLogin()">Login</button>" +
   *              "</form>"
   *      })
   * class LoginComp {
   *  loginForm:ControlGroup;
   * 
   *  constructor() {
   *    this.loginForm = new ControlGroup({
   *      login: new Control(""),
   *    });
   *  }
   * 
   *  onLogin() {
   *    // this.loginForm.value
   *  }
   * }
   * 
   *  ```
   * 
   * @exportedAs angular2/forms
   */
  class ControlNameDirective extends  ControlDirective {
    control: Control;
    formDirective: any;
    model: any;
    ngModel: EventEmitter;
    onChange(c: StringMap<string, any>): any;
    onDestroy(): any;
    path: List<string>;
    viewToModelUpdate(newValue: any): void;
  }
  

  /**
   * Binds a control to a DOM element.
   * 
   * # Example
   * 
   * In this example, we bind the control to an input element. When the value of the input element
   * changes, the value of
   * the control will reflect that change. Likewise, if the value of the control changes, the input
   * element reflects that
   * change.
   * 
   * Here we use <a href='/angular2/angular2/formDirectives'><code>formDirectives</code></a>, rather than importing each form directive individually, e.g.
   * `ControlDirective`, `ControlGroupDirective`. This is just a shorthand for the same end result.
   * 
   *  ```
   * @Component({selector: "login-comp"})
   * @View({
   *      directives: [formDirectives],
   *      template: "<input type='text' [ng-form-control]='loginControl'>"
   *      })
   * class LoginComp {
   *  loginControl:Control;
   * 
   *  constructor() {
   *    this.loginControl = new Control('');
   *  }
   * }
   * 
   *  ```
   * 
   * @exportedAs angular2/forms
   */
  class FormControlDirective extends  ControlDirective {
    control: Control;
    form: Control;
    model: any;
    ngModel: EventEmitter;
    onChange(c: any): any;
    path: List<string>;
    viewToModelUpdate(newValue: any): void;
  }
  
  class NgModelDirective extends  ControlDirective {
    control: Control;
    model: any;
    ngModel: EventEmitter;
    onChange(c: any): any;
    path: List<string>;
    viewToModelUpdate(newValue: any): void;
  }
  

  /**
   * A directive that bind a [ng-control] object to a DOM element.
   * 
   * @exportedAs angular2/forms
   */
  class ControlDirective {
    control: Control;
    name: string;
    path: List<string>;
    validator: Function;
    valueAccessor: ControlValueAccessor;
    viewToModelUpdate(newValue: any): void;
  }
  

  /**
   * Binds a ng-control group to a DOM element.
   * 
   * # Example
   * 
   * In this example, we create a ng-control group, and we bind the login and
   * password controls to the login and password elements.
   * 
   * Here we use <a href='/angular2/angular2/formDirectives'><code>formDirectives</code></a>, rather than importing each form directive individually, e.g.
   * `ControlDirective`, `ControlGroupDirective`. This is just a shorthand for the same end result.
   * 
   *  ```
   * @Component({selector: "login-comp"})
   * @View({
   *      directives: [formDirectives],
   *      template:
   *              "<form [ng-form-model]='loginForm'>" +
   *              "<div ng-control-group="credentials">
   *              "Login <input type='text' ng-control='login'>" +
   *              "Password <input type='password' ng-control='password'>" +
   *              "<button (click)="onLogin()">Login</button>" +
   *              "</div>"
   *              "</form>"
   *      })
   * class LoginComp {
   *  loginForm:ControlGroup;
   * 
   *  constructor() {
   *    this.loginForm = new ControlGroup({
   *      credentials: new ControlGroup({
   *        login: new Cntrol(""),
   *        password: new Control("")
   *      })
   *    });
   *  }
   * 
   *  onLogin() {
   *    // this.loginForm.value
   *  }
   * }
   * 
   *  ```
   * 
   * @exportedAs angular2/forms
   */
  class ControlGroupDirective extends  ControlContainerDirective {
    formDirective: any;
    onDestroy(): any;
    onInit(): any;
    path: List<string>;
  }
  

  /**
   * Binds a control group to a DOM element.
   * 
   * # Example
   * 
   * In this example, we bind the control group to the form element, and we bind the login and
   * password controls to the
   * login and password elements.
   * 
   * Here we use <a href='/angular2/angular2/formDirectives'><code>formDirectives</code></a>, rather than importing each form directive individually, e.g.
   * `ControlDirective`, `ControlGroupDirective`. This is just a shorthand for the same end result.
   * 
   *  ```
   * @Component({selector: "login-comp"})
   * @View({
   *      directives: [formDirectives],
   *      template: "<form [ng-form-model]='loginForm'>" +
   *              "Login <input type='text' ng-control='login'>" +
   *              "Password <input type='password' ng-control='password'>" +
   *              "<button (click)="onLogin()">Login</button>" +
   *              "</form>"
   *      })
   * class LoginComp {
   *  loginForm:ControlGroup;
   * 
   *  constructor() {
   *    this.loginForm = new ControlGroup({
   *      login: new Control(""),
   *      password: new Control("")
   *    });
   *  }
   * 
   *  onLogin() {
   *    // this.loginForm.value
   *  }
   * }
   * 
   *  ```
   * 
   * @exportedAs angular2/forms
   */
  class FormModelDirective extends  ControlContainerDirective implements  FormDirective {
    addControl(dir: ControlDirective): void;
    addControlGroup(dir: ControlGroupDirective): any;
    directives: List<ControlDirective>;
    form: ControlGroup;
    formDirective: FormDirective;
    getControl(dir: ControlDirective): Control;
    onChange(_: any): any;
    path: List<string>;
    removeControl(dir: ControlDirective): void;
    removeControlGroup(dir: ControlGroupDirective): any;
    updateModel(dir: ControlDirective, value: any): void;
  }
  
  class TemplateDrivenFormDirective extends  ControlContainerDirective implements 
    FormDirective {
    addControl(dir: ControlDirective): void;
    addControlGroup(dir: ControlGroupDirective): void;
    controls: StringMap<string, AbstractControl>;
    form: ControlGroup;
    formDirective: FormDirective;
    getControl(dir: ControlDirective): Control;
    path: List<string>;
    removeControl(dir: ControlDirective): void;
    removeControlGroup(dir: ControlGroupDirective): void;
    updateModel(dir: ControlDirective, value: any): void;
    value: any;
  }
  
  interface ControlValueAccessor {
    registerOnChange(fn: any): void;
    registerOnTouched(fn: any): void;
    writeValue(obj: any): void;
  }
  

  /**
   * The default accessor for writing a value and listening to changes that is used by a
   * <a href='Control'>Control</a> directive.
   * 
   * This is the default strategy that Angular uses when no other accessor is applied.
   * 
   *  # Example
   *  ```
   *  <input type="text" [ng-form-control]="loginControl">
   *  ```
   * 
   * @exportedAs angular2/forms
   */
  class DefaultValueAccessor implements  ControlValueAccessor {
    cd: ControlDirective;
    onChange: Function;
    onTouched: Function;
    registerOnChange(fn: Function): void;
    registerOnTouched(fn: Function): void;
    value: any;
    writeValue(value: any): any;
  }
  

  /**
   * The accessor for writing a value and listening to changes on a checkbox input element.
   * 
   * 
   *  # Example
   *  ```
   *  <input type="checkbox" [ng-control]="rememberLogin">
   *  ```
   * 
   * @exportedAs angular2/forms
   */
  class CheckboxControlValueAccessor implements  ControlValueAccessor {
    cd: ControlDirective;
    checked: boolean;
    onChange: Function;
    onTouched: Function;
    registerOnChange(fn: Function): void;
    registerOnTouched(fn: Function): void;
    writeValue(value: any): any;
  }
  

  /**
   * The accessor for writing a value and listening to changes that is used by a
   * <a href='Control'>Control</a> directive.
   * 
   * This is the default strategy that Angular uses when no other accessor is applied.
   * 
   *  # Example
   *  ```
   *  <input type="text" [ng-control]="loginControl">
   *  ```
   * 
   * @exportedAs angular2/forms
   */
  class SelectControlValueAccessor implements  ControlValueAccessor {
    cd: ControlDirective;
    onChange: Function;
    onTouched: Function;
    registerOnChange(fn: Function): void;
    registerOnTouched(fn: Function): void;
    value: any;
    writeValue(value: any): any;
  }
  

  /**
   * A list of all the form directives used as part of a `@View` annotation.
   * 
   *  This is a shorthand for importing them each individually.
   * 
   * @exportedAs angular2/forms
   */
  var formDirectives : List<Type> ;
  

  /**
   * Provides a set of validators used by form controls.
   * 
   * # Example
   * 
   * ```
   * var loginControl = new Control("", Validators.required)
   * ```
   * 
   * @exportedAs angular2/forms
   */
  class Validators {
  }
  
  class RequiredValidatorDirective {
  }
  

  /**
   * Creates a form object from a user-specified configuration.
   * 
   * # Example
   * 
   * ```
   * import {Component, View, bootstrap} from 'angular2/angular2';
   * import {FormBuilder, Validators, formDirectives, ControlGroup} from 'angular2/forms';
   * 
   * @Component({
   *   selector: 'login-comp',
   *   appInjector: [
   *     FormBuilder
   *   ]
   * })
   * @View({
   *   template: `
   *     <form [control-group]="loginForm">
   *       Login <input control="login">
   * 
   *       <div control-group="passwordRetry">
   *         Password <input type="password" control="password">
   *         Confirm password <input type="password" control="passwordConfirmation">
   *       </div>
   *     </form>
   *   `,
   *   directives: [
   *     formDirectives
   *   ]
   * })
   * class LoginComp {
   *   loginForm: ControlGroup;
   * 
   *   constructor(builder: FormBuilder) {
   *     this.loginForm = builder.group({
   *       login: ["", Validators.required],
   * 
   *       passwordRetry: builder.group({
   *         password: ["", Validators.required],
   *         passwordConfirmation: ["", Validators.required]
   *       })
   *     });
   *   }
   * }
   * 
   * bootstrap(LoginComp)
   * ```
   * 
   * This example creates a <a href='ControlGroup'>ControlGroup</a> that consists of a `login` <a href='Control'>Control</a>, and a
   * nested
   * <a href='ControlGroup'>ControlGroup</a> that defines a `password` and a `passwordConfirmation` <a href='Control'>Control</a>:
   * 
   * ```
   *  var loginForm = builder.group({
   *    login: ["", Validators.required],
   * 
   *    passwordRetry: builder.group({
   *      password: ["", Validators.required],
   *      passwordConfirmation: ["", Validators.required]
   *    })
   *  });
   * 
   *  ```
   * @exportedAs angular2/forms
   */
  class FormBuilder {
    array(controlsConfig: List<any>, validator?: Function): ControlArray;
    control(value: Object, validator?: Function): Control;
    group(controlsConfig: StringMap<string, any>, extra?: StringMap<string, any>): ControlGroup;
  }
  
  function resolveBindings(bindings: List<Type | Binding | List<any>>) : List<ResolvedBinding> ;
  

  /**
   * A dependency injection container used for resolving dependencies.
   * 
   * An `Injector` is a replacement for a `new` operator, which can automatically resolve the
   * constructor dependencies.
   * In typical use, application code asks for the dependencies in the constructor and they are
   * resolved by the `Injector`.
   * 
   * ## Example:
   * 
   * Suppose that we want to inject an `Engine` into class `Car`, we would define it like this:
   * 
   * ```javascript
   * class Engine {
   * }
   * 
   * class Car {
   *   constructor(@Inject(Engine) engine) {
   *   }
   * }
   * 
   * ```
   * 
   * Next we need to write the code that creates and instantiates the `Injector`. We then ask for the
   * `root` object, `Car`, so that the `Injector` can recursively build all of that object's
   * dependencies.
   * 
   * ```javascript
   * main() {
   *   var injector = Injector.resolveAndCreate([Car, Engine]);
   * 
   *   // Get a reference to the `root` object, which will recursively instantiate the tree.
   *   var car = injector.get(Car);
   * }
   * ```
   * Notice that we don't use the `new` operator because we explicitly want to have the `Injector`
   * resolve all of the object's dependencies automatically.
   * 
   * @exportedAs angular2/di
   */
  class Injector {

    /**
     * Retrieves an instance from the injector asynchronously. Used with asynchronous bindings.
     * 
     * @param `token`: usually a `Type`. (Same as token used while setting up a binding).
     * @returns a `Promise` which resolves to the instance represented by the token.
     */
    asyncGet(token: any): Promise<any>;

    /**
     * Creates a child injector and loads a new set of <a href='/angular2/angular2/ResolvedBinding'><code>ResolvedBinding</code></a>s into it.
     * 
     * @param `bindings`: A sparse list of <a href='/angular2/angular2/ResolvedBinding'><code>ResolvedBinding</code></a>s.
     * See `resolve` for the <a href='/angular2/angular2/Injector'><code>Injector</code></a>.
     * @returns a new child <a href='/angular2/angular2/Injector'><code>Injector</code></a>.
     */
    createChildFromResolved(bindings: List<ResolvedBinding>): Injector;

    /**
     * Retrieves an instance from the injector.
     * 
     * @param `token`: usually the `Type` of an object. (Same as the token used while setting up a
     * binding).
     * @returns an instance represented by the token. Throws if not found.
     */
    get(token: any): any;

    /**
     * Retrieves an instance from the injector.
     * 
     * @param `token`: usually a `Type`. (Same as the token used while setting up a binding).
     * @returns an instance represented by the token. Returns `null` if not found.
     */
    getOptional(token: any): any;

    /**
     * Direct parent of this injector.
     */
    parent: Injector;

    /**
     * Creates a child injector and loads a new set of bindings into it.
     * 
     * A resolution is a process of flattening multiple nested lists and converting individual
     * bindings into a list of <a href='/angular2/angular2/ResolvedBinding'><code>ResolvedBinding</code></a>s. The resolution can be cached by `resolve`
     * for the <a href='/angular2/angular2/Injector'><code>Injector</code></a> for performance-sensitive code.
     * 
     * @param `bindings` can be a list of `Type`, <a href='/angular2/angular2/Binding'><code>Binding</code></a>, <a href='/angular2/angular2/ResolvedBinding'><code>ResolvedBinding</code></a>, or a
     * recursive list of more bindings.
     */
    resolveAndCreateChild(bindings: List<Type | Binding | List<any>>): Injector;
  }
  

  /**
   * Describes how the <a href='/angular2/angular2/Injector'><code>Injector</code></a> should instantiate a given token.
   * 
   * See <a href='/angular2/angular2/bind'><code>bind</code></a>.
   * 
   * ## Example
   * 
   * ```javascript
   * var injector = Injector.resolveAndCreate([
   *   new Binding(String, { toValue: 'Hello' })
   * ]);
   * 
   * expect(injector.get(String)).toEqual('Hello');
   * ```
   * 
   * @exportedAs angular2/di
   */
  class Binding {

    /**
     * Used in conjunction with `toFactory` or `toAsyncFactory` and specifies a set of dependencies
     * (as `token`s) which should be injected into the factory function.
     * 
     * ## Example
     * 
     * ```javascript
     * var injector = Injector.resolveAndCreate([
     *   new Binding(Number, { toFactory: () => { return 1+2; }}),
     *   new Binding(String, { toFactory: (value) => { return "Value: " + value; },
     *                         dependencies: [Number] })
     * ]);
     * 
     * expect(injector.get(Number)).toEqual(3);
     * expect(injector.get(String)).toEqual('Value: 3');
     * ```
     */
    dependencies: List<any>;

    /**
     * Converts the <a href='/angular2/angular2/Binding'><code>Binding</code></a> into <a href='/angular2/angular2/ResolvedBinding'><code>ResolvedBinding</code></a>.
     * 
     * <a href='/angular2/angular2/Injector'><code>Injector</code></a> internally only uses <a href='/angular2/angular2/ResolvedBinding'><code>ResolvedBinding</code></a>, <a href='/angular2/angular2/Binding'><code>Binding</code></a> contains
     * convenience binding syntax.
     */
    resolve(): ResolvedBinding;

    /**
     * Binds a key to the alias for an existing key.
     * 
     * An alias means that <a href='/angular2/angular2/Injector'><code>Injector</code></a> returns the same instance as if the alias token was used.
     * This is in contrast to `toClass` where a separate instance of `toClass` is returned.
     * 
     * ## Example
     * 
     * Becuse `toAlias` and `toClass` are often confused the example contains both use cases for easy
     * comparison.
     * 
     * ```javascript
     * 
     * class Vehicle {}
     * 
     * class Car extends Vehicle {}
     * 
     * var injectorAlias = Injector.resolveAndCreate([
     *   Car,
     *   new Binding(Vehicle, { toAlias: Car })
     * ]);
     * var injectorClass = Injector.resolveAndCreate([
     *   Car,
     *   new Binding(Vehicle, { toClass: Car })
     * ]);
     * 
     * expect(injectorAlias.get(Vehicle)).toBe(injectorAlias.get(Car));
     * expect(injectorAlias.get(Vehicle) instanceof Car).toBe(true);
     * 
     * expect(injectorClass.get(Vehicle)).not.toBe(injectorClass.get(Car));
     * expect(injectorClass.get(Vehicle) instanceof Car).toBe(true);
     * ```
     */
    toAlias: any;

    /**
     * Binds a key to a function which computes the value asynchronously.
     * 
     * ## Example
     * 
     * ```javascript
     * var injector = Injector.resolveAndCreate([
     *   new Binding(Number, { toAsyncFactory: () => {
     *     return new Promise((resolve) => resolve(1 + 2));
     *   }}),
     *   new Binding(String, { toFactory: (value) => { return "Value: " + value; },
     *                         dependencies: [Number]})
     * ]);
     * 
     * injector.asyncGet(Number).then((v) => expect(v).toBe(3));
     * injector.asyncGet(String).then((v) => expect(v).toBe('Value: 3'));
     * ```
     * 
     * The interesting thing to note is that event though `Number` has an async factory, the `String`
     * factory function takes the resolved value. This shows that the <a href='/angular2/angular2/Injector'><code>Injector</code></a> delays
     * executing the
     * `String` factory
     * until after the `Number` is resolved. This can only be done if the `token` is retrieved using
     * the `asyncGet` API in the <a href='/angular2/angular2/Injector'><code>Injector</code></a>.
     */
    toAsyncFactory: Function;

    /**
     * Binds an interface to an implementation / subclass.
     * 
     * ## Example
     * 
     * Becuse `toAlias` and `toClass` are often confused, the example contains both use cases for easy
     * comparison.
     * 
     * ```javascript
     * 
     * class Vehicle {}
     * 
     * class Car extends Vehicle {}
     * 
     * var injectorClass = Injector.resolveAndCreate([
     *   Car,
     *   new Binding(Vehicle, { toClass: Car })
     * ]);
     * var injectorAlias = Injector.resolveAndCreate([
     *   Car,
     *   new Binding(Vehicle, { toAlias: Car })
     * ]);
     * 
     * expect(injectorClass.get(Vehicle)).not.toBe(injectorClass.get(Car));
     * expect(injectorClass.get(Vehicle) instanceof Car).toBe(true);
     * 
     * expect(injectorAlias.get(Vehicle)).toBe(injectorAlias.get(Car));
     * expect(injectorAlias.get(Vehicle) instanceof Car).toBe(true);
     * ```
     */
    toClass: Type;

    /**
     * Binds a key to a function which computes the value.
     * 
     * ## Example
     * 
     * ```javascript
     * var injector = Injector.resolveAndCreate([
     *   new Binding(Number, { toFactory: () => { return 1+2; }}),
     *   new Binding(String, { toFactory: (value) => { return "Value: " + value; },
     *                         dependencies: [Number] })
     * ]);
     * 
     * expect(injector.get(Number)).toEqual(3);
     * expect(injector.get(String)).toEqual('Value: 3');
     * ```
     */
    toFactory: Function;

    /**
     * Binds a key to a value.
     * 
     * ## Example
     * 
     * ```javascript
     * var injector = Injector.resolveAndCreate([
     *   new Binding(String, { toValue: 'Hello' })
     * ]);
     * 
     * expect(injector.get(String)).toEqual('Hello');
     * ```
     */
    toValue: any;

    /**
     * Token used when retrieving this binding. Usually the `Type`.
     */
    token: any;
  }
  

  /**
   * Helper class for the <a href='/angular2/angular2/bind'><code>bind</code></a> function.
   * 
   * @exportedAs angular2/di
   */
  class BindingBuilder {

    /**
     * Binds a key to the alias for an existing key.
     * 
     * An alias means that we will return the same instance as if the alias token was used. (This is
     * in contrast to `toClass` where a separet instance of `toClass` will be returned.)
     * 
     * ## Example
     * 
     * Becuse `toAlias` and `toClass` are often confused, the example contains both use cases for easy
     * comparison.
     * 
     * ```javascript
     * 
     * class Vehicle {}
     * 
     * class Car extends Vehicle {}
     * 
     * var injectorAlias = Injector.resolveAndCreate([
     *   Car,
     *   bind(Vehicle).toAlias(Car)
     * ]);
     * var injectorClass = Injector.resolveAndCreate([
     *   Car,
     *   bind(Vehicle).toClass(Car)
     * ]);
     * 
     * expect(injectorAlias.get(Vehicle)).toBe(injectorAlias.get(Car));
     * expect(injectorAlias.get(Vehicle) instanceof Car).toBe(true);
     * 
     * expect(injectorClass.get(Vehicle)).not.toBe(injectorClass.get(Car));
     * expect(injectorClass.get(Vehicle) instanceof Car).toBe(true);
     * ```
     */
    toAlias(aliasToken: any): Binding;

    /**
     * Binds a key to a function which computes the value asynchronously.
     * 
     * ## Example
     * 
     * ```javascript
     * var injector = Injector.resolveAndCreate([
     *   bind(Number).toAsyncFactory(() => {
     *     return new Promise((resolve) => resolve(1 + 2));
     *   }),
     *   bind(String).toFactory((v) => { return "Value: " + v; }, [Number])
     * ]);
     * 
     * injector.asyncGet(Number).then((v) => expect(v).toBe(3));
     * injector.asyncGet(String).then((v) => expect(v).toBe('Value: 3'));
     * ```
     * 
     * The interesting thing to note is that event though `Number` has an async factory, the `String`
     * factory function takes the resolved value. This shows that the <a href='/angular2/angular2/Injector'><code>Injector</code></a> delays
     * executing of the `String` factory
     * until after the `Number` is resolved. This can only be done if the `token` is retrieved using
     * the `asyncGet` API in the <a href='/angular2/angular2/Injector'><code>Injector</code></a>.
     */
    toAsyncFactory(factoryFunction: Function, dependencies?: List<any>): Binding;

    /**
     * Binds an interface to an implementation / subclass.
     * 
     * ## Example
     * 
     * Because `toAlias` and `toClass` are often confused, the example contains both use cases for
     * easy comparison.
     * 
     * ```javascript
     * 
     * class Vehicle {}
     * 
     * class Car extends Vehicle {}
     * 
     * var injectorClass = Injector.resolveAndCreate([
     *   Car,
     *   bind(Vehicle).toClass(Car)
     * ]);
     * var injectorAlias = Injector.resolveAndCreate([
     *   Car,
     *   bind(Vehicle).toAlias(Car)
     * ]);
     * 
     * expect(injectorClass.get(Vehicle)).not.toBe(injectorClass.get(Car));
     * expect(injectorClass.get(Vehicle) instanceof Car).toBe(true);
     * 
     * expect(injectorAlias.get(Vehicle)).toBe(injectorAlias.get(Car));
     * expect(injectorAlias.get(Vehicle) instanceof Car).toBe(true);
     * ```
     */
    toClass(type: Type): Binding;

    /**
     * Binds a key to a function which computes the value.
     * 
     * ## Example
     * 
     * ```javascript
     * var injector = Injector.resolveAndCreate([
     *   bind(Number).toFactory(() => { return 1+2; }),
     *   bind(String).toFactory((v) => { return "Value: " + v; }, [Number])
     * ]);
     * 
     * expect(injector.get(Number)).toEqual(3);
     * expect(injector.get(String)).toEqual('Value: 3');
     * ```
     */
    toFactory(factoryFunction: Function, dependencies?: List<any>): Binding;

    /**
     * Binds a key to a value.
     * 
     * ## Example
     * 
     * ```javascript
     * var injector = Injector.resolveAndCreate([
     *   bind(String).toValue('Hello')
     * ]);
     * 
     * expect(injector.get(String)).toEqual('Hello');
     * ```
     */
    toValue(value: any): Binding;
    token: any;
  }
  

  /**
   * An internal resolved representation of a <a href='/angular2/angular2/Binding'><code>Binding</code></a> used by the <a href='/angular2/angular2/Injector'><code>Injector</code></a>.
   * 
   * A <a href='/angular2/angular2/Binding'><code>Binding</code></a> is resolved when it has a factory function. Binding to a class, alias, or
   * value, are just convenience methods, as <a href='/angular2/angular2/Injector'><code>Injector</code></a> only operates on calling factory
   * functions.
   * 
   * @exportedAs angular2/di
   */
  class ResolvedBinding {

    /**
     * Arguments (dependencies) to the `factory` function.
     */
    dependencies: List<Dependency>;

    /**
     * Factory function which can return an instance of an object represented by a key.
     */
    factory: Function;

    /**
     * A key, usually a `Type`.
     */
    key: Key;

    /**
     * Specifies whether the `factory` function returns a `Promise`.
     */
    providedAsPromise: boolean;
  }
  

  /**
   * @private
   */
  class Dependency {
    asPromise: boolean;
    key: Key;
    lazy: boolean;
    optional: boolean;
    properties: List<any>;
  }
  

  /**
   * Provides an API for imperatively constructing <a href='/angular2/angular2/Binding'><code>Binding</code></a>s.
   * 
   * This is only relevant for JavaScript. See <a href='/angular2/angular2/BindingBuilder'><code>BindingBuilder</code></a>.
   * 
   * ## Example
   * 
   * ```javascript
   * bind(MyInterface).toClass(MyClass)
   * 
   * ```
   * 
   * @exportedAs angular2/di
   */
  function bind(token: any) : BindingBuilder ;
  

  /**
   * A unique object used for retrieving items from the <a href='/angular2/angular2/Injector'><code>Injector</code></a>.
   * 
   * Keys have:
   * - a system-wide unique `id`.
   * - a `token`, usually the `Type` of the instance.
   * 
   * Keys are used internally by the <a href='/angular2/angular2/Injector'><code>Injector</code></a> because their system-wide unique `id`s allow the
   * injector to index in arrays rather than looking up items in maps.
   * 
   * @exportedAs angular2/di
   */
  class Key {
    displayName: any;
    id: number;
    token: Object;
  }
  

  /**
   * @private
   */
  class KeyRegistry {
    get(token: Object): Key;
    numberOfKeys: any;
  }
  

  /**
   * Type literals is a Dart-only feature. This is here only so we can x-compile
   * to multiple languages.
   */
  class TypeLiteral {
    type: any;
  }
  

  /**
   * Thrown when trying to retrieve a dependency by `Key` from <a href='/angular2/angular2/Injector'><code>Injector</code></a>, but the
   * <a href='/angular2/angular2/Injector'><code>Injector</code></a> does not have a <a href='/angular2/angular2/Binding'><code>Binding</code></a> for <a href='/angular2/angular2/Key'><code>Key</code></a>.
   * 
   * @exportedAs angular2/di_errors
   */
  class NoBindingError extends  AbstractBindingError {
  }
  

  /**
   * Base class for all errors arising from misconfigured bindings.
   * 
   * @exportedAs angular2/di_errors
   */
  class AbstractBindingError extends  BaseException {
    addKey(key: any): void;
    constructResolvingMessage: Function;
    keys: List<any>;
    message: string;
    name: string;
    toString(): string;
  }
  

  /**
   * Thrown when trying to retrieve an async <a href='/angular2/angular2/Binding'><code>Binding</code></a> using the sync API.
   * 
   * ## Example
   * 
   * ```javascript
   * var injector = Injector.resolveAndCreate([
   *   bind(Number).toAsyncFactory(() => {
   *     return new Promise((resolve) => resolve(1 + 2));
   *   }),
   *   bind(String).toFactory((v) => { return "Value: " + v; }, [String])
   * ]);
   * 
   * injector.asyncGet(String).then((v) => expect(v).toBe('Value: 3'));
   * expect(() => {
   *   injector.get(String);
   * }).toThrowError(AsycBindingError);
   * ```
   * 
   * The above example throws because `String` depends on `Number` which is async. If any binding in
   * the dependency graph is async then the graph can only be retrieved using the `asyncGet` API.
   * 
   * @exportedAs angular2/di_errors
   */
  class AsyncBindingError extends  AbstractBindingError {
  }
  

  /**
   * Thrown when dependencies form a cycle.
   * 
   * ## Example:
   * 
   * ```javascript
   * class A {
   *   constructor(b:B) {}
   * }
   * class B {
   *   constructor(a:A) {}
   * }
   * ```
   * 
   * Retrieving `A` or `B` throws a `CyclicDependencyError` as the graph above cannot be constructed.
   * 
   * @exportedAs angular2/di_errors
   */
  class CyclicDependencyError extends  AbstractBindingError {
  }
  

  /**
   * Thrown when a constructing type returns with an Error.
   * 
   * The `InstantiationError` class contains the original error plus the dependency graph which caused
   * this object to be instantiated.
   * 
   * @exportedAs angular2/di_errors
   */
  class InstantiationError extends  AbstractBindingError {
    cause: any;
    causeKey: any;
  }
  

  /**
   * Thrown when an object other then <a href='/angular2/angular2/Binding'><code>Binding</code></a> (or `Type`) is passed to <a href='/angular2/angular2/Injector'><code>Injector</code></a>
   * creation.
   * 
   * @exportedAs angular2/di_errors
   */
  class InvalidBindingError extends  BaseException {
    message: string;
    toString(): string;
  }
  

  /**
   * Thrown when the class has no annotation information.
   * 
   * Lack of annotation information prevents the <a href='/angular2/angular2/Injector'><code>Injector</code></a> from determining which dependencies
   * need to be injected into the constructor.
   * 
   * @exportedAs angular2/di_errors
   */
  class NoAnnotationError extends  BaseException {
    message: string;
    name: string;
    toString(): string;
  }
  

  /**
   * @exportedAs angular2/di
   */
  class OpaqueToken {
    toString(): string;
  }
  

  /**
   * A parameter annotation that specifies a dependency.
   * 
   * ```
   * class AComponent {
   *   constructor(@Inject(MyService) aService:MyService) {}
   * }
   * ```
   * 
   * @exportedAs angular2/di_annotations
   */
  class InjectAnnotation {
    token: any;
  }
  

  /**
   * A parameter annotation that specifies a `Promise` of a dependency.
   * 
   * ```
   * class AComponent {
   *   constructor(@InjectPromise(MyService) aServicePromise:Promise<MyService>) {
   *     aServicePromise.then(aService:MyService => ...);
   *   }
   * }
   * ```
   * 
   * @exportedAs angular2/di_annotations
   */
  class InjectPromiseAnnotation {
    token: any;
  }
  

  /**
   * A parameter annotation that creates a synchronous lazy dependency.
   * 
   * ```
   * class AComponent {
   *   constructor(@InjectLazy(MyService) aServiceFn:Function) {
   *     var aService:MyService = aServiceFn();
   *   }
   * }
   * ```
   * 
   * @exportedAs angular2/di_annotations
   */
  class InjectLazyAnnotation {
    token: any;
  }
  

  /**
   * A parameter annotation that marks a dependency as optional. <a href='/angular2/angular2/Injector'><code>Injector</code></a> provides `null` if
   * the dependency is not found.
   * 
   * ```
   * class AComponent {
   *   constructor(@Optional() aService:MyService) {
   *     this.aService = aService;
   *   }
   * }
   * ```
   * 
   * @exportedAs angular2/di_annotations
   */
  class OptionalAnnotation {
  }
  

  /**
   * A marker annotation that marks a class as available to `Injector` for creation. Used by tooling
   * for generating constructor stubs.
   * 
   * ```
   * class NeedsService {
   *   constructor(svc:UsefulService) {}
   * }
   * 
   * @Injectable
   * class UsefulService {}
   * ```
   * @exportedAs angular2/di_annotations
   */
  class InjectableAnnotation {
  }
  

  /**
   * `DependencyAnnotation` is used by the framework to extend DI.
   * 
   * Only annotations implementing `DependencyAnnotation` are added to the list of dependency
   * properties.
   * 
   * For example:
   * 
   * ```
   * class Parent extends DependencyAnnotation {}
   * class NotDependencyProperty {}
   * 
   * class AComponent {
   *   constructor(@Parent @NotDependencyProperty aService:AService) {}
   * }
   * ```
   * 
   * will create the following dependency:
   * 
   * ```
   * new Dependency(Key.get(AService), [new Parent()])
   * ```
   * 
   * The framework can use `new Parent()` to handle the `aService` dependency
   * in a specific way.
   * 
   * @exportedAs angular2/di_annotations
   */
  class DependencyAnnotation {
    token: any;
  }
  
  var Inject: any;
  
  var InjectPromise: any;
  
  var InjectLazy: any;
  
  var Optional: any;
  
  interface ForwardRefFn {
  }
  

  /**
   * Allows to refer to references which are not yet defined.
   * 
   * This situation arises when the key which we need te refer to for the purposes of DI is declared,
   * but not yet defined.
   * 
   * ## Example:
   * 
   * ```
   * class Door {
   *   // Incorrect way to refer to a reference which is defined later.
   *   // This fails because `Lock` is undefined at this point.
   *   constructor(lock:Lock) { }
   * 
   *   // Correct way to refer to a reference which is defined later.
   *   // The reference needs to be captured in a closure.
   *   constructor(@Inject(forwardRef(() => Lock)) lock:Lock) { }
   * }
   * 
   * // Only at this point the lock is defined.
   * class Lock {
   * }
   * ```
   * 
   * @exportedAs angular2/di
   */
  function forwardRef(forwardRefFn: ForwardRefFn) : Type ;
  
  var FORWARD_REF: any;
  

  /**
   * Lazily retrieve the reference value.
   * 
   * See: <a href='/angular2/angular2/forwardRef'><code>forwardRef</code></a>
   * 
   * @exportedAs angular2/di
   */
  function resolveForwardRef(type: any) : any ;
  

  /**
   * General notes:
   * 
   * The methods for creating / destroying views in this API are used in the AppViewHydrator
   * and RenderViewHydrator as well.
   * 
   * We are already parsing expressions on the render side:
   * - this makes the ElementBinders more compact
   *   (e.g. no need to distinguish interpolations from regular expressions from literals)
   * - allows to retrieve which properties should be accessed from the event
   *   by looking at the expression
   * - we need the parse at least for the `template` attribute to match
   *   directives in it
   * - render compiler is not on the critical path as
   *   its output will be stored in precompiled templates.
   */
  class EventBinding {
    fullName: string;
    source: ASTWithSource;
  }
  
  class ElementBinder {
    directives: List<DirectiveBinder>;
    distanceToParent: number;
    eventBindings: List<EventBinding>;
    index: number;
    nestedProtoView: ProtoViewDto;
    parentIndex: number;
    propertyBindings: Map<string, ASTWithSource>;
    readAttributes: Map<string, string>;
    textBindings: List<ASTWithSource>;
    variableBindings: Map<string, ASTWithSource>;
  }
  
  class DirectiveBinder {
    directiveIndex: number;
    eventBindings: List<EventBinding>;
    hostPropertyBindings: Map<string, ASTWithSource>;
    propertyBindings: Map<string, ASTWithSource>;
  }
  
  class ProtoViewDto {
    elementBinders: List<ElementBinder>;
    render: RenderProtoViewRef;
    type: number;
    variableBindings: Map<string, string>;
  }
  
  class DirectiveMetadata {
    callOnAllChangesDone: boolean;
    callOnChange: boolean;
    callOnCheck: boolean;
    callOnDestroy: boolean;
    callOnInit: boolean;
    changeDetection: string;
    compileChildren: boolean;
    events: List<string>;
    hostActions: Map<string, string>;
    hostAttributes: Map<string, string>;
    hostListeners: Map<string, string>;
    hostProperties: Map<string, string>;
    id: any;
    properties: List<string>;
    readAttributes: List<string>;
    selector: string;
    type: number;
  }
  
  class RenderProtoViewRef {
  }
  
  class RenderViewRef {
  }
  
  class ViewDefinition {
    absUrl: string;
    componentId: string;
    directives: List<DirectiveMetadata>;
    template: string;
  }
  
  class RenderCompiler {

    /**
     * Compiles a single DomProtoView. Non recursive so that
     * we don't need to serialize all possible components over the wire,
     * but only the needed ones based on previous calls.
     */
    compile(template: ViewDefinition): Promise<ProtoViewDto>;

    /**
     * Creats a ProtoViewDto that contains a single nested component with the given componentId.
     */
    compileHost(directiveMetadata: DirectiveMetadata): Promise<ProtoViewDto>;
  }
  
  class Renderer {

    /**
     * Attaches a componentView into the given hostView at the given element
     */
    attachComponentView(hostViewRef: RenderViewRef, elementIndex: number, componentViewRef: RenderViewRef): any;

    /**
     * Attaches a view into a ViewContainer (in the given parentView at the given element) at the
     * given index.
     */
    attachViewInContainer(parentViewRef: RenderViewRef, boundElementIndex: number, atIndex: number, viewRef: RenderViewRef): any;

    /**
     * Calls an action.
     * Note: This will fail if the action was not mentioned previously as a host action
     * in the ProtoView
     */
    callAction(viewRef: RenderViewRef, elementIndex: number, actionExpression: string, actionArgs: any): any;

    /**
     * Creates a root host view that includes the given element.
     * @param {RenderProtoViewRef} hostProtoViewRef a RenderProtoViewRef of type
     * ProtoViewDto.HOST_VIEW_TYPE
     * @param {any} hostElementSelector css selector for the host element (will be queried against the
     * main document)
     * @return {RenderViewRef} the created view
     */
    createRootHostView(hostProtoViewRef: RenderProtoViewRef, hostElementSelector: string): RenderViewRef;

    /**
     * Creates a regular view out of the given ProtoView
     */
    createView(protoViewRef: RenderProtoViewRef): RenderViewRef;

    /**
     * Dehydrates a view after it has been attached. Hydration/dehydration is used for reusing views
     * inside of the view pool.
     */
    dehydrateView(viewRef: RenderViewRef): any;

    /**
     * Destroys the given view after it has been dehydrated and detached
     */
    destroyView(viewRef: RenderViewRef): any;

    /**
     * Detaches a componentView into the given hostView at the given element
     */
    detachComponentView(hostViewRef: RenderViewRef, boundElementIndex: number, componentViewRef: RenderViewRef): any;

    /**
     * Detaches a free view's element from the DOM.
     */
    detachFreeView(view: RenderViewRef): any;

    /**
     * Detaches a view into a ViewContainer (in the given parentView at the given element) at the
     * given index.
     */
    detachViewInContainer(parentViewRef: RenderViewRef, boundElementIndex: number, atIndex: number, viewRef: RenderViewRef): any;

    /**
     * Hydrates a view after it has been attached. Hydration/dehydration is used for reusing views
     * inside of the view pool.
     */
    hydrateView(viewRef: RenderViewRef): any;

    /**
     * Sets a property on an element.
     * Note: This will fail if the property was not mentioned previously as a host property
     * in the ProtoView
     */
    setElementProperty(viewRef: RenderViewRef, elementIndex: number, propertyName: string, propertyValue: any): any;

    /**
     * Sets the dispatcher for all events of the given view
     */
    setEventDispatcher(viewRef: RenderViewRef, dispatcher: EventDispatcher): any;

    /**
     * Sets the value of a text node.
     */
    setText(viewRef: RenderViewRef, textNodeIndex: number, text: string): any;
  }
  

  /**
   * A dispatcher for all events happening in a view.
   */
  interface EventDispatcher {

    /**
     * Called when an event was triggered for a on-* attribute on an element.
     * @param {Map<string, any>} locals Locals to be used to evaluate the
     *   event expressions
     */
    dispatchEvent(elementIndex: number, eventName: string, locals: Map<string, any>): any;
  }
  
  class TreeNode<T extends TreeNode<any>> {
    /**
     * Adds a child to the parent node. The child MUST NOT be a part of a tree.
     */
    addChild(child: T): void;

    /**
     * Adds a child to the parent node after a given sibling.
     * The child MUST NOT be a part of a tree and the sibling must be present.
     */
    addChildAfter(child: T, prevSibling: T): void;
    children: any;
    parent: any;

    /**
     * Detaches a node from the parent's tree.
     */
    remove(): void;
  }
  
  class DependencyWithVisibility extends  Dependency {
    visibility: Visibility;
  }
  
  class DirectiveDependency extends  DependencyWithVisibility {
    attributeName: string;
    queryDirective: any;
  }
  
  class DirectiveBinding extends  ResolvedBinding {
    callOnAllChangesDone: boolean;
    callOnChange: boolean;
    callOnDestroy: boolean;
    changeDetection: any;
    displayName: string;
    eventEmitters: List<string>;
    hostActions: Map<string, string>;
    metadata: DirectiveMetadata;
    resolvedAppInjectables: List<ResolvedBinding>;
    resolvedHostInjectables: List<ResolvedBinding>;
    resolvedViewInjectables: List<ResolvedBinding>;
  }
  
  class PreBuiltObjects {
    protoView: AppProtoView;
    view: AppView;
    viewManager: AppViewManager;
  }
  
  class EventEmitterAccessor {
    eventName: string;
    getter: Function;
    subscribe(view:AppView, boundElementIndex: number, directive: Object): any;
  }
  
  class HostActionAccessor {
    actionExpression: string;
    getter: Function;
    subscribe(view:AppView, boundElementIndex: number, directive: Object): any;
  }
  
  class BindingData {
    binding: ResolvedBinding;
    createEventEmitterAccessors(): any;
    createHostActionAccessors(): any;
    getKeyId(): any;
    visibility: number;
  }
  

  /**
   * Difference between di.Injector and ElementInjector
   * 
   * di.Injector:
   *  - imperative based (can create child injectors imperativly)
   *  - Lazy loading of code
   *  - Component/App Level services which are usually not DOM Related.
   * 
   * 
   * ElementInjector:
   *   - ProtoBased (Injector structure fixed at compile time)
   *   - understands @Ancestor, @Parent, @Child, @Descendent
   *   - Fast
   *   - Query mechanism for children
   *   - 1:1 to DOM structure.
   * 
   *  PERF BENCHMARK:
   * http://www.williambrownstreet.net/blog/2014/04/faster-angularjs-rendering-angularjs-and-reactjs/
   */
  class ProtoElementInjector {
    attributes: Map<string, string>;
    directParent(): ProtoElementInjector;
    distanceToParent: number;
    eventEmitterAccessors: List<List<EventEmitterAccessor>>;

    /**
     * Whether the component instance is exported as $implicit.
     */
    exportComponent: boolean;

    /**
     * Whether the element is exported as $implicit.
     */
    exportElement: boolean;

    /**
     * The variable name that will be set to $implicit for the element.
     */
    exportImplicitName: string;
    getBindingAtIndex(index: number): any;
    hasBindings: boolean;
    hostActionAccessors: List<List<HostActionAccessor>>;
    index: int;
    instantiate(parent: ElementInjector): ElementInjector;
    parent: ProtoElementInjector;
    view: AppView;
  }
  
  class ElementInjector extends  TreeNode<ElementInjector> {
    dehydrate(): void;
    directParent(): ElementInjector;
    dynamicallyCreateComponent(componentDirective: DirectiveBinding, parentInjector: Injector): any;
    get(token: any): any;
    getBoundElementIndex(): number;
    getComponent(): any;
    getDirectiveAtIndex(index: number): any;
    getDynamicallyLoadedComponent(): any;
    getElementRef(): ElementRef;
    getEventEmitterAccessors(): List<List<EventEmitterAccessor>>;

    /**
     * Get the name to which this element's $implicit is to be assigned.
     */
    getExportImplicitName(): string;
    getHost(): ElementInjector;
    getHostActionAccessors(): List<List<HostActionAccessor>>;
    getLightDomAppInjector(): Injector;
    getShadowDomAppInjector(): Injector;
    getViewContainerRef(): ViewContainerRef;
    hasDirective(type: Type): boolean;
    hasInstances(): boolean;
    hydrate(injector: Injector, host: ElementInjector, preBuiltObjects: PreBuiltObjects): void;

    /**
     * Gets whether this element is exporting a component instance as $implicit.
     */
    isExportingComponent(): boolean;

    /**
     * Gets whether this element is exporting its element as $implicit.
     */
    isExportingElement(): boolean;
    link(parent: ElementInjector): void;
    linkAfter(parent: ElementInjector, prevSibling: ElementInjector): void;
    unlink(): void;
  }
  
  class EmptyExpr extends  AST {
    eval(context: any, locals: any): any;
    visit(visitor: any): any;
  }
  

  /**
   * Multiple expressions separated by a semicolon.
   */
  class Chain extends  AST {
    eval(context: any, locals: any): any;
    expressions: List<any>;
    visit(visitor: any): any;
  }
  
  class Conditional extends  AST {
    condition: AST;
    eval(context: any, locals: any): any;
    falseExp: AST;
    trueExp: AST;
    visit(visitor: any): any;
  }
  
  class SafeAccessMember extends  AST {
    eval(context: any, locals: any): any;
    getter: Function;
    name: string;
    receiver: AST;
    setter: Function;
    visit(visitor: any): any;
  }
  
  class KeyedAccess extends  AST {
    assign(context: any, locals: any, value: any): any;
    eval(context: any, locals: any): any;
    isAssignable: boolean;
    key: AST;
    obj: AST;
    visit(visitor: any): any;
  }
  
  class LiteralPrimitive extends  AST {
    eval(context: any, locals: any): any;
    value: any;
    visit(visitor: any): any;
  }
  
  class LiteralMap extends  AST {
    eval(context: any, locals: any): any;
    keys: List<any>;
    values: List<any>;
    visit(visitor: any): any;
  }
  
  class Interpolation extends  AST {
    eval(context: any, locals: any): any;
    expressions: List<any>;
    strings: List<any>;
    visit(visitor: any): any;
  }
  
  class Binary extends  AST {
    eval(context: any, locals: any): any;
    left: AST;
    operation: string;
    right: AST;
    visit(visitor: any): any;
  }
  
  class PrefixNot extends  AST {
    eval(context: any, locals: any): any;
    expression: AST;
    visit(visitor: any): any;
  }
  
  class Assignment extends  AST {
    eval(context: any, locals: any): any;
    target: AST;
    value: AST;
    visit(visitor: any): any;
  }
  
  class MethodCall extends  AST {
    args: List<any>;
    eval(context: any, locals: any): any;
    fn: Function;
    name: string;
    receiver: AST;
    visit(visitor: any): any;
  }
  
  class SafeMethodCall extends  AST {
    args: List<any>;
    eval(context: any, locals: any): any;
    fn: Function;
    name: string;
    receiver: AST;
    visit(visitor: any): any;
  }
  
  class FunctionCall extends  AST {
    args: List<any>;
    eval(context: any, locals: any): any;
    target: AST;
    visit(visitor: any): any;
  }
  
  class TemplateBinding {
    expression: ASTWithSource;
    key: string;
    keyIsVar: boolean;
    name: string;
  }
  
  class AstVisitor {
    visitAccessMember(ast: AccessMember): any;
    visitAssignment(ast: Assignment): any;
    visitBinary(ast: Binary): any;
    visitChain(ast: Chain): any;
    visitConditional(ast: Conditional): any;
    visitFunctionCall(ast: FunctionCall): any;
    visitImplicitReceiver(ast: ImplicitReceiver): any;
    visitKeyedAccess(ast: KeyedAccess): any;
    visitLiteralArray(ast: LiteralArray): any;
    visitLiteralMap(ast: LiteralMap): any;
    visitLiteralPrimitive(ast: LiteralPrimitive): any;
    visitMethodCall(ast: MethodCall): any;
    visitPipe(ast: Pipe): any;
    visitPrefixNot(ast: PrefixNot): any;
    visitSafeAccessMember(ast: SafeAccessMember): any;
    visitSafeMethodCall(ast: SafeMethodCall): any;
  }
  
}



