import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
import { NgModule, Component }      from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import { FormsModule } from '@angular/forms';
import {TemperaturePipe} from './temperature-pipe';

@Component({
    selector: 'app',
    template:`<input type='text' value="0"
              placeholder= "Podaj temperaturę" [(ngModel)] = "temp">
              <button (click)="toggleFormat()">Przełącz format</button>
              <br>W formacie {{targetFormat}} ta temperatura wynosi {{temp | temperature: format | number:'1.1-2'}}`

})
class AppComponent {

    temp: number;
    toCelsius: boolean=true;
    targetFormat: string ='Celsjusz';
    format: string='FtoC';

    toggleFormat(){

        this.toCelsius = !this.toCelsius;
        this.format = this.toCelsius? 'FtoC': 'CtoF';

        this.targetFormat = this.toCelsius?'Celsjusz':'Fahrenheit';
    }
}
@NgModule({
    imports:      [ BrowserModule, FormsModule],
    declarations: [ AppComponent, TemperaturePipe],
    bootstrap:    [ AppComponent ]
})
class AppModule { }

platformBrowserDynamic().bootstrapModule(AppModule);