import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
import { NgModule, Component }      from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';

@Component({
    selector: 'app',
    template: `
    <button (click)="flag = !flag">Przełącz wartość flagi</button>

    <p>
      Wartość flagi: {{flag}}
    </p>

    <p>
     1. span z *ngIf="flag": <span *ngIf="flag">Flaga ma wartość true</span>
    </p>

    <p>
      2. template z [ngIf]="flag": <template [ngIf]="flag">Flaga ma wartość true</template>
    </p>
  `
})
class AppComponent {
    flag: boolean = true;
}

@NgModule({
    imports:      [ BrowserModule],
    declarations: [ AppComponent],
    bootstrap:    [ AppComponent ]
})
class AppModule { }

platformBrowserDynamic().bootstrapModule(AppModule);