import {bootstrap} from '@angular/platform-browser-dynamic';
import {Component} from '@angular/core';
import {HTTP_PROVIDERS} from '@angular/http';
import {ProductService} from "./product-service";

@Component({
  selector: 'http-client',
  providers: [ ProductService ],
  template: `<h1>Znajdź produkt wg ID przy użyciu ProductService</h1>
     <form #f="ngForm" (ngSubmit) = "getProductByID(f.value)" >
       <label for="productID">Wpisz ID produktu</label>
       <input id="productID" type="number" ngControl="productID">
       <button type="submit">Znajdź produkt</button>
     </form>

     <h4>{{ productTitle}} {{productPrice}}</h4>

  `})
class AppComponent {

  productTitle: string;
  productPrice: string;

  constructor(private productService: ProductService) {}

  getProductByID(formValue){
      this.productService.getProductByID(formValue.productID)
        .subscribe(
            data => {
              this.productTitle = data.title;
              this.productPrice =`$` + data.price;
            },
            err => console.log("Nie można pobrać szczegółów produktów. Kod błędu: %s ",  err.status, err.url),
            () =>    console.log( 'Zrobione')
        );
  }
}

bootstrap(AppComponent, [HTTP_PROVIDERS]);
