/// <reference path="PayBand.ts" />

module Payroll {
    export interface IPayable {

        increasePay(percent: number): boolean
    }

    class Person {
        // properties are omitted for brevity

        constructor() {
        }
    }

    export class Employee extends Person implements IPayable {

        increasePay(percent: number): boolean {

            console.log("Zwiększenie wynagrodzenia o",percent);
            return true;
        }
    }

    export class Contractor implements IPayable {
        increaseCap: number = 20;

        increasePay(percent: number): boolean {
            if (percent < this.increaseCap) {
                console.log("Zwiększenie stawki godzinowej o ", percent);
                return true;
            } else {
                console.log("Przepraszamy, limit zwiększania stawki dla podwykonawców wynosi", this.increaseCap);
                return false;
            }
        }
    }

}

var workers: Array<Payroll.IPayable> = [];
workers[0] = new Payroll.Employee();
workers[1] = new Payroll.Contractor();

workers.forEach((worker) => worker.increasePay(30));

