import * as express from "express";
import * as path from "path";
//import * as ws from "ws";
import {Server} from "ws";

const app = express();

app.use('/', express.static(path.join(__dirname, '..', 'client')));
app.use('/node_modules', express.static(path.join(__dirname, '..', 'node_modules')));

// HTTP Server
app.get('/', (req, res) => {

    res.sendFile(path.join(__dirname, '..', 'client/simple-websocket-client.html'));
});

const httpServer = app.listen(8000, "localhost", () => {

    const {port} = httpServer.address();

    console.log('Serwer HTTP nasłuchuje na porcie %s', port);
});

// WebSocket Server
var wsServer: Server = new Server({port:8085});

console.log('Serwer WebSocket nasłuchuje na porcie 8085');

wsServer.on('connection',
           websocket => {
               websocket.send('Ten komunikat został wysłany przez serwer WebSocket');
           });

// Broadcasting to all clients
/*
wsServer.on('connection',
    websocket => wsServer.clients
        .forEach(
            client =>client.send('This message was pushed by the WebSocket server')));*/
