import {Component, Input} from '@angular/core';
import {Stock} from './stock';

@Component({
    selector: 'order-processor',
    template: `{{message}}`,
    styles:[`:host {background: cyan;}`]
})
export class OrderComponent {

    message:string = "Oczekiwanie na zlecenia...";

    private _stock: Stock;

    @Input() set stock(value: Stock ){
        if (value && value.bidPrice != undefined) {
            this.message = `Złożono zlecenie na zakup 100 akcji
                          spółki ${value.stockSymbol} po cenie \$${value.bidPrice.toFixed(2)}`;
        }
    }

    get stock(): Stock{
        return this._stock;
    }
}

