import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
import { NgModule, Component }      from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';

@Component({
  selector: 'app',
  template: `
    <h3>Porównanie wiązania właściwości i atrybutów:</h3>
    <input [value]="greeting" [attr.value] = "greeting" (input)="onInputEvent($event)">
  `
})
class AppComponent {

  greeting: string = 'Jakaś wartość';

  onInputEvent(event: Event): void {
    let inputElement: HTMLInputElement = <HTMLInputElement> event.target;

    console.log(`Wartość właściwości input = ${inputElement.value}`);
    console.log(`Wartość atrybutu input = ${inputElement.getAttribute('value')}`);
    console.log(`Wartość właściwości greeting = ${this.greeting}`);
  }
}

@NgModule({
  imports:      [ BrowserModule],
  declarations: [ AppComponent],
  bootstrap:    [ AppComponent ]
})
class AppModule { }

platformBrowserDynamic().bootstrapModule(AppModule);









/*

// Using destructuring

onInputEvent({target}): void {

  console.log(`The input property value = ${target.value}`);
console.log(`The input attribute value = ${target.getAttribute('value')}`);
console.log(`The greeting property value = ${this.greeting}`);
}
}
*/