import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
import { NgModule, Component }      from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import {LocationStrategy, HashLocationStrategy} from '@angular/common';
import {RouterModule} from "@angular/router";
import {HomeComponent} from "./components/home";
import {ProductDetailComponent} from "./components/product";
import {LuxuryModule} from "./components/luxury/luxury.module";

@Component({
    selector: 'app',
    template: `
        <a [routerLink]="['/']">Strona główna</a>
        <a [routerLink]="['/product']">Szczegóły produktu</a>
        <a [routerLink]="['/luxury']">Przedmioty luksusowe</a>
        <router-outlet></router-outlet>
    `
})
export class AppComponent {}

@NgModule({
    imports: [ BrowserModule,
               LuxuryModule,
               RouterModule.forRoot([
                   {path: '',        component: HomeComponent},
                   {path: 'product', component: ProductDetailComponent}
                   ])
              ],
    declarations: [ AppComponent, HomeComponent, ProductDetailComponent],
    providers:[{provide: LocationStrategy, useClass: HashLocationStrategy}],
    bootstrap:    [ AppComponent ]
})
class AppModule { }

platformBrowserDynamic().bootstrapModule(AppModule);

