import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
import { NgModule, Component}      from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';

@Component({
  selector: 'child',
  styles: ['.child {background: lightgreen;}'],
  template: `
    <div class="child">
     <h2>Komponent potomny</h2>
      <ng-content select=".header" ></ng-content>
      <div>Ta zawartość jest zdefiniowana w komponencie potomnym</div>
      <ng-content select=".footer"></ng-content>
    </div>
  `
})
class ChildComponent {}

@Component({
  selector: 'app',
  styles: ['.app {background: cyan;}'],
  template: `
    <div class="app">
     <h2>Komponent nadrzędny</h2>
      <div>Ten element div jest zdefiniowany w szablonie komponentu nadrzędnego</div>
      <child>
        <div class="header" >Komponent potomny ma ten nagłówek z komponentu nadrzędnego {{todaysDate}}</div>
        <div class="footer">Komponent potomny ma tę stopkę z komponentu nadrzędnego</div>
      </child>
    </div>
  `
})
class AppComponent {
  todaysDate: string = new Date().toLocaleDateString();
}

@NgModule({
  imports:      [ BrowserModule],
  declarations: [ AppComponent, ChildComponent],
  bootstrap:    [ AppComponent ]
})
class AppModule { }

platformBrowserDynamic().bootstrapModule(AppModule);

