import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
import { NgModule, Component, Input,  OnChanges, SimpleChange, enableProdMode } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import {FormsModule} from '@angular/forms';

interface IChanges {[key: string]: SimpleChange};

@Component({
  selector: 'child',
  styles: ['.child{background:lightgreen}'],
  template: `
     <div class="child">
      <h2>Komponent potomny</h2>
      <div>Przywitanie: {{greeting}}</div>
      <div>Nazwa użytkownika: {{user.name}}</div>
      <div>Wiadomość: <input [(ngModel)]="message"></div>
    </div>
  `
})
class ChildComponent implements OnChanges {
  @Input() greeting: string;
  @Input() user: {name: string};
  message: string = 'Wiadomość początkowa';

  ngOnChanges(changes: IChanges) {
    console.log(JSON.stringify(changes, null, 2));
  }
}

@Component({
  selector: 'app',
  styles: ['.parent {background: lightblue}'],
  template: `
     <div class="parent">
       <h2>Komponent nadrzędny</h2>
      <div>Przywitanie: <input type="text" [value]="greeting" (change)="greeting = $event.target.value"></div>
      <div>Nazwa użytkownika: <input type="text" [value]="user.name" (change)="user.name = $event.target.value"></div>
      <child [greeting]="greeting" [user]="user"></child>
    </div>
  `
})
class AppComponent {
  greeting: string = 'Witaj';
  user: {name: string} = {name: 'Jaś'};
}

enableProdMode();

@NgModule({
  imports:      [ BrowserModule, FormsModule],
  declarations: [ AppComponent, ChildComponent],
  bootstrap:    [ AppComponent ]
})
class AppModule { }

platformBrowserDynamic().bootstrapModule(AppModule);
