import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
import { NgModule, Component }      from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';

import {WebSocketService} from "./websocket-observable-service";

@Component({
  selector: 'app',
  providers: [ WebSocketService ],
  template: `<h1>Subskrybent Angular usługi WebSocket</h1>
       {{messageFromServer}}<br>
       <button (click)="sendMessageToServer()">Wyślij komunikat do serwera</button>
  `})
class AppComponent {

  messageFromServer: string;

  constructor(private wsService: WebSocketService) {

      this.wsService.createObservableSocket("ws://localhost:8085")
        .subscribe(
            data => {
              this.messageFromServer = data;
            },
            err => console.log( err),
            () =>  console.log( 'Strumień obserwowalny jest zakończony')
        );
  }

    sendMessageToServer(){
        console.log("Wysyłanie komunikatu do serwera WebSocket");

        this.wsService.sendMessage("Pozdrowienia od klienta");
    }
}

@NgModule({
    imports:      [ BrowserModule],
    declarations: [ AppComponent],
    bootstrap:    [ AppComponent ]
})
class AppModule { }
platformBrowserDynamic().bootstrapModule(AppModule);
