/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

import android.util.Log;
import com.google.android.apps.analytics.GoogleAnalyticsTracker;
import java.io.IOException;
import java.net.Socket;
import org.apache.http.Header;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

class PipelinedRequester {
    private static final int RECEIVE_BUFFER_SIZE = 8192;
    DefaultHttpClientConnection connection = new DefaultHttpClientConnection();
    Callbacks callbacks;
    int lastStatusCode;
    boolean canPipeline = true;
    HttpHost host;
    SocketFactory socketFactory;

    public PipelinedRequester(HttpHost httpHost) {
        this(httpHost, (SocketFactory)new PlainSocketFactory());
    }

    public PipelinedRequester(HttpHost httpHost, SocketFactory socketFactory) {
        this.host = httpHost;
        this.socketFactory = socketFactory;
    }

    public void installCallbacks(Callbacks callbacks) {
        this.callbacks = callbacks;
    }

    public void addRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        this.maybeOpenConnection();
        this.connection.sendRequestHeader((HttpRequest)httpEntityEnclosingRequest);
        this.connection.sendRequestEntity(httpEntityEnclosingRequest);
    }

    public void sendRequests() throws IOException, HttpException {
        this.connection.flush();
        HttpConnectionMetrics httpConnectionMetrics = this.connection.getMetrics();
        while (httpConnectionMetrics.getResponseCount() < httpConnectionMetrics.getRequestCount()) {
            Header[] headerArray;
            HttpResponse httpResponse = this.connection.receiveResponseHeader();
            if (!httpResponse.getStatusLine().getProtocolVersion().greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                this.callbacks.pipelineModeChanged(false);
                this.canPipeline = false;
            }
            if ((headerArray = httpResponse.getHeaders("Connection")) != null) {
                for (Header header : headerArray) {
                    if (!"close".equalsIgnoreCase(header.getValue())) continue;
                    this.callbacks.pipelineModeChanged(false);
                    this.canPipeline = false;
                }
            }
            this.lastStatusCode = httpResponse.getStatusLine().getStatusCode();
            if (this.lastStatusCode != 200) {
                this.callbacks.serverError(this.lastStatusCode);
                this.closeConnection();
                return;
            }
            this.connection.receiveResponseEntity(httpResponse);
            httpResponse.getEntity().consumeContent();
            this.callbacks.requestSent();
            if (GoogleAnalyticsTracker.getInstance().getDebug()) {
                Log.v((String)"GoogleAnalyticsTracker", (String)("HTTP Response Code: " + httpResponse.getStatusLine().getStatusCode()));
            }
            if (this.canPipeline) continue;
            this.closeConnection();
            return;
        }
    }

    public void finishedCurrentRequests() {
        this.closeConnection();
    }

    private void maybeOpenConnection() throws IOException {
        if (this.connection == null || !this.connection.isOpen()) {
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            Socket socket = this.socketFactory.createSocket();
            socket = this.socketFactory.connectSocket(socket, this.host.getHostName(), this.host.getPort(), null, 0, (HttpParams)basicHttpParams);
            socket.setReceiveBufferSize(8192);
            this.connection.bind(socket, (HttpParams)basicHttpParams);
        }
    }

    private void closeConnection() {
        if (this.connection != null && this.connection.isOpen()) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static interface Callbacks {
        public void pipelineModeChanged(boolean var1);

        public void serverError(int var1);

        public void requestSent();
    }
}

