/*
 * Decompiled with CFR 0.152.
 */
package com.hfad.coffeina;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

class CoffeinaDatabaseHelper
extends SQLiteOpenHelper {
    private static final String DB_NAME = "coffeina";
    private static final int DB_VERSION = 2;

    CoffeinaDatabaseHelper(Context context) {
        super(context, DB_NAME, null, 2);
    }

    public void onCreate(SQLiteDatabase db) {
        this.updateMyDatabase(db, 0, 2);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.updateMyDatabase(db, oldVersion, newVersion);
    }

    private static void insertDrink(SQLiteDatabase db, String name, String description, int resourceId) {
        ContentValues drinkValues = new ContentValues();
        drinkValues.put("NAME", name);
        drinkValues.put("DESCRIPTION", description);
        drinkValues.put("IMAGE_RESOURCE_ID", Integer.valueOf(resourceId));
        db.insert("DRINK", null, drinkValues);
    }

    private void updateMyDatabase(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 1) {
            db.execSQL("CREATE TABLE DRINK (_id INTEGER PRIMARY KEY AUTOINCREMENT, NAME TEXT, DESCRIPTION TEXT, IMAGE_RESOURCE_ID INTEGER);");
            CoffeinaDatabaseHelper.insertDrink(db, "Latte", "Czarne espresso z gor\u0105cym mlekiem i mleczn\u0105 piank\u0105.", 2130968581);
            CoffeinaDatabaseHelper.insertDrink(db, "Cappuccino", "Czarne espresso z du\u017c\u0105 ilo\u015bci\u0105 spienionego mleka.", 2130968577);
            CoffeinaDatabaseHelper.insertDrink(db, "Espresso", "Czarna kawa ze \u015bwie\u017co mielonych ziaren najwy\u017cszej jako\u015bci.", 2130968578);
        }
        if (oldVersion < 2) {
            db.execSQL("ALTER TABLE DRINK ADD COLUMN FAVORITE NUMERIC;");
        }
    }
}

