#!/bin/python
#
# BrowserFuzz
#
# Amir Etemadieh
# Joshua J. Drake
#
# Ten plik zawiera kod generujacy strony HTML w oparciu o tagi HTML z tags.py.
#

import random


TYPEDARRAY_TYPES = [
    'Array',
    'ArrayBuffer',
    'ArrayBufferView',
    'DataView',
    'StringView',
    'Int8Array',
    'Uint8Array',
    'Uint8ClampedArray',
    'Int16Array',
    'Uint16Array',
    'Int32Array',
    'Uint32Array',
    'Float32Array',
    'Float64Array'
]

#
# Wygeneruj strone HTML do fuzzingu
#
def generate_page():
    page = """<html>
<head>
  <title>BrowserFuzz</title>
<script type='text/javascript'>
function boom() {
  console.log("========================= boom start =========================");

"""
    # najpierw utworz tablice z losowo wybranymi typem i rozmiarem
    page += "  try { " + generate_var() + " } catch(e) { console.log(e); }\n"
    page += "\n"

    # nastepnie przypisz losowo wybrany typ
    page += "  try { " + generate_assignment() + " } catch(e) { console.log(e); }\n"
    
    # zakoncz strone
    page += """
  console.log("========================= boom end =========================");
}
</script>
</head>
<body onload='javascript:boom()'>
hi!
</body>
</html>
"""
    return page

def generate_var():
    vtype = random.choice(TYPEDARRAY_TYPES)
    vlen = rand_num()
    return "var arr1 = new %s(%d);" % (vtype, vlen)

def generate_assignment():
    vtype = random.choice(TYPEDARRAY_TYPES)
    return "var arr2 = new %s(arr1);" % (vtype)

#
# Wybierz liczbe, dowolna liczbe...
#
def rand_num():
    divisor = random.randrange(0x8) + 1
    dividend = (0x100000000 / divisor)
    if random.randrange(3) == 0:
        addend = random.randrange(10)
        addend -= 5
        dividend += addend
    return dividend

#
# do testowania...
#   
if __name__ == "__main__":
    print generate_page(),

