package pl.twojadomena.rozdzial_7_a;

import java.util.Random;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

public class Kwadraty extends View {

	public Kwadraty(Context context) {
		super(context);
	}

	public Kwadraty(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public Kwadraty(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
	}
	@Override
	protected void onDraw(Canvas canvas) {
		int szer = getWidth();
		int wys = getHeight();
		Paint p = new Paint();
		p.setAntiAlias(true);

		p.setStyle(Paint.Style.FILL);
		Random r = new Random();
		for( int i = 0; i < 10; i++)
		{
			p.setARGB( 255, r.nextInt(256), r.nextInt(256), r.nextInt(256));
			canvas.drawCircle( r.nextInt( szer), r.nextInt( wys), r.nextInt( 100), p);
		}
		
		p.setStyle(Paint.Style.STROKE);
		p.setStrokeWidth( 5);
		p.setColor( Color.YELLOW);
		canvas.drawRect( 2, 2, szer-3, wys-3, p);

		super.onDraw(canvas);
	}
	@Override
	protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) 
	{
	    int szer = 300;
	    int wys = 300;

	    int szerMode = MeasureSpec.getMode(widthMeasureSpec);
	    int szerAktual = MeasureSpec.getSize(widthMeasureSpec);
	    int wysMode = MeasureSpec.getMode(heightMeasureSpec);
	    int wysAktual = MeasureSpec.getSize(heightMeasureSpec);

	    switch( szerMode)			//ustawienie szerokosci
	    {
	    case MeasureSpec.EXACTLY:	//dokadnie
	    	szer = szerAktual;
	    	break;
	    case MeasureSpec.AT_MOST:	//nie wicej
	    	if( szer > szerAktual)
	    		szer = szerAktual;
	    	break;
	    default:					//obojtnie
	    	break;
	    }

	    switch( wysMode)			//ustawienie wysokosci
	    {
	    case MeasureSpec.EXACTLY:	//dokadnie
	    	wys = wysAktual;
	    	break;
	    case MeasureSpec.AT_MOST:	//nie wicej
	    	if( wys > wysAktual)
	    		wys = wysAktual;
	    	break;
	    default:					//obojtnie
	    	break;
	    }
	    setMeasuredDimension( szer, wys);
	}
}
