package pl.twojadomena.rozdzial_10_1;

import java.io.InputStream;
import java.net.URL;

import pl.twojadomena.rozdzial_10_1.KsiezycActivity.OdczytObrazka;
import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

public class IssActivity extends Activity 
{
	private String adres = "http://www.heavens-above.com/orbitdisplay.aspx?icon=iss&width=300&height=300&satid=25544"; 
//	private String adres = "http://api.usno.navy.mil/imagery/moon.png";
//	private String adres = "http://sdo.gsfc.nasa.gov/assets/img/latest/latest_512_4500.jpg";
	private Button przycisk;
	private ImageView obraz;
	private ProgressBar stan;
	private TextView napis; 
	private Bitmap bmp;

	@Override
	protected void onCreate(Bundle savedInstanceState) 
	{
		super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_iss);
        
        przycisk = (Button) findViewById(R.id.button1);
        obraz = (ImageView) findViewById(R.id.imageView1);
        napis = (TextView) findViewById(R.id.textView1);
        stan = (ProgressBar) findViewById(R.id.progressBar1);

        OdczytObrazka oo = new OdczytObrazka();
    	oo.execute();
	}
	public void kliknieto_powrot( View v)
	{
		finish();
	}
	//------------------------------------------------------------------------------
    class OdczytObrazka extends AsyncTask<Void, Void, Void>
    {
    	boolean sukces=true;
    	@Override
    	protected Void doInBackground( Void... arg0) 
    	{
    		URL u;
    		InputStream is;
    		try
    		{
    			u = new URL( adres);
    			is = u.openStream();
    			Bitmap temp = BitmapFactory.decodeStream(is);
    	        bmp=temp.copy(Bitmap.Config.ARGB_8888, true);
    		}
    		catch( Exception e)
    		{
    			sukces = false;
    		}
    		return null;
    	}
    	@Override
    	protected void onPreExecute() 
    	{
			stan.setVisibility( ProgressBar.VISIBLE);
			przycisk.setEnabled(false);
			napis.setText( "Pobieranie danych ...");
    		super.onPreExecute();
    	}
    	@Override
    	protected void onPostExecute(Void result) 
    	{
			if( sukces)
			{
				Canvas c = new Canvas( bmp);
				Paint p = new Paint();
		    	int szer = bmp.getWidth(), wys = bmp.getHeight();
		    	p.setColor(Color.WHITE);
		    	p.setStyle(Paint.Style.STROKE);
		    	c.drawRect(0, 0, szer-1, wys-1, p);

		    	obraz.setImageBitmap( bmp);
				napis.setText( "Pobieranie danych zakoczone.");
			}
			else
			{
				napis.setText( "Bd podczas pobierania danych.");
			}
			przycisk.setEnabled(true);
			stan.setVisibility( ProgressBar.INVISIBLE);
    		super.onPostExecute(result);
    	}
    }
}
