/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gameproject.multiplayerpaddle;

//import com.gameproject.tabletpaddle.GameView;

import android.annotation.TargetApi;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.View.OnClickListener;
import android.view.inputmethod.EditorInfo;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

/**
 * To gwna Aktywno wywietlajc biec sesj komunikacji.
 */
@TargetApi(11)
public class BluetoothChat extends Activity {
    // Debugowanie
    private static final String TAG = "BluetoothChat";
    private static final boolean D = true;

    // Rodzaje komunikatw wysyane do procedury BluetoothChatService
    public static final int MESSAGE_STATE_CHANGE = 1;
    public static final int MESSAGE_READ = 2;
    public static final int MESSAGE_WRITE = 3;
    public static final int MESSAGE_DEVICE_NAME = 4;
    public static final int MESSAGE_TOAST = 5;

    // Klucze nazw otrzymywanych z procedury BluetoothChatService
    public static final String DEVICE_NAME = "device_name";
    public static final String TOAST = "toast";

    // Kody da
    private static final int REQUEST_CONNECT_DEVICE = 1;
    private static final int REQUEST_ENABLE_BT = 2;

    // Widoki
    private TextView mTitle;
    private ListView mConversationView;
    private EditText mOutEditText;
    private Button mSendButton;

    
	GameView mGameView;
	
    // Nazwa poczonego urzdzenia
    private String mConnectedDeviceName = null;
    // Tablica przechowujca tre komunikacji
    private ArrayAdapter<String> mConversationArrayAdapter;
    // Bufor wiadomoci wychodzcych
    private StringBuffer mOutStringBuffer;
    // Lokalny adapter Bluetooth
    private BluetoothAdapter BlueAdapter = null;
    // Obiekt usugi komunikacji
    private BluetoothChatService mChatService = null;


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if(D) Log.e(TAG, "+++ ON CREATE +++");
        



        Log.e("GAMEVIEW","GAMEVIEW Hzaincjalizowana!!!");
        

        // Utwrz gwne okno
        requestWindowFeature(Window.FEATURE_CUSTOM_TITLE);
        getWindow().setFeatureInt(Window.FEATURE_CUSTOM_TITLE, R.layout.custom_title);

        // Utwrz tytu okna
       // mTitle = (TextView) findViewById(R.id.title_left_text);
       // mTitle.setText(R.string.app_name);
       // mTitle = (TextView) findViewById(R.id.title_right_text);

        BlueAdapter = BluetoothAdapter.getDefaultAdapter();

        if (BlueAdapter == null) {
            Toast.makeText(this, "Interfejs Bluetooth nie jest dostpny", Toast.LENGTH_LONG).show();
            return;
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if(D) Log.e(TAG, "++ ON START ++");

        // Jeeli interfejs nie jest wczony zadaj jego wczenia.
        // nastpnei wywoaj setupChat() podczas onActivityResult
        if (!BlueAdapter.isEnabled()) {
            Intent enableIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
            startActivityForResult(enableIntent, REQUEST_ENABLE_BT);
        // W przeciwnym wypadku skonfiguruj sesj komunikacji
        } else {
            if (mChatService == null) startgame();
        }
    }

    @Override
    public synchronized void onResume() {
        super.onResume();
        if(D) Log.e(TAG, "+ ON RESUME +");

        // Wykonanie tego testu w trakcie onResume() obsuguje przypadek w ktrym Bluetooth
        // nie by aktywny w trakcie onStart(), dlatego konieczne byo spauzowanei programu...
        // onResume() bdzie wywoana w momencie otrzymania ACTION_REQUEST_ENABLE .
        if (mChatService != null) {
            // Jedynie gdy stan jest STATE_NONE, Czy wiemy e komunikacja nie zostaa ju rozpoczta?
            if (mChatService.getState() == BluetoothChatService.STATE_NONE) {
              // Uruchom usugi komunikacji
              mChatService.start();
            }
        }
    }

    private void startgame() {
        Log.d(TAG, "setupChat()");

        mGameView = new GameView(this, mHandler);
        setContentView(mGameView);
        

    }

    @Override
    public synchronized void onPause() {
        super.onPause();
        if(D) Log.e(TAG, "- ON PAUSE -");
    }

    @Override
    public void onStop() {
        super.onStop();
        if(D) Log.e(TAG, "-- ON STOP --");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        // Zatrzymaj usugi komunikacji
        if (mChatService != null) mChatService.stop();
        if(D) Log.e(TAG, "--- ON DESTROY ---");
    }

    private void ensureDiscoverable() {
        if(D) Log.d(TAG, "zapewnij wykrywalno");
        if (BlueAdapter.getScanMode() !=
            BluetoothAdapter.SCAN_MODE_CONNECTABLE_DISCOVERABLE) {
            Intent discoverableIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_DISCOVERABLE);
            discoverableIntent.putExtra(BluetoothAdapter.EXTRA_DISCOVERABLE_DURATION, 300);
            startActivity(discoverableIntent);
        }
    }

    /**
     * Wysya komunikat
     * @param message  acuch tekstowy do wysania.
     */
    private void sendMessage(String message) {
        // Przed rozpoczciem czegokolwiek sprawd poczenie
        if (mChatService.getState() != BluetoothChatService.STATE_CONNECTED) {
            Toast.makeText(this, R.string.not_connected, Toast.LENGTH_SHORT).show();
            return;
        }

        // Sprawd czy jest cokolwiek do wysania
        if (message.length() > 0) {
            // Pobierz komunikat i wyslij
            byte[] send = message.getBytes();
            mChatService.write(send);

            // Wyzeruj bufor 
            mOutStringBuffer.setLength(0);
            mOutEditText.setText(mOutStringBuffer);
        }
    }

    // Metoda nasuchujca dla widetu EditText
    private TextView.OnEditorActionListener mWriteListener =
        new TextView.OnEditorActionListener() {
        public boolean onEditorAction(TextView view, int actionId, KeyEvent event) {
            // Jeeli puszczono klawisz return wylij komunikat
            if (actionId == EditorInfo.IME_NULL && event.getAction() == KeyEvent.ACTION_UP) {
                String message = view.getText().toString();
                sendMessage(message);
            }
            if(D) Log.i(TAG, "END onEditorAction");
            return true;
        }
    };

    // Procedura odbierajca informacje z  BluetoothChatService
    private final Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
            case MESSAGE_STATE_CHANGE:
                if(D) Log.i(TAG, "MESSAGE_STATE_CHANGE: " + msg.arg1);
                switch (msg.arg1) {
                case BluetoothChatService.STATE_CONNECTED:
                    mTitle.setText(R.string.title_connected_to);
                    mTitle.append(mConnectedDeviceName);
                    mConversationArrayAdapter.clear();
                    break;
                case BluetoothChatService.STATE_CONNECTING:
                    mTitle.setText(R.string.title_connecting);
                    break;
                case BluetoothChatService.STATE_LISTEN:
                case BluetoothChatService.STATE_NONE:
                    mTitle.setText(R.string.title_not_connected);
                    break;
                }
                break;
            case MESSAGE_WRITE:
                byte[] writeBuf = (byte[]) msg.obj;
                // utwrz acuch z bufora
                String writeMessage = new String(writeBuf);
                mConversationArrayAdapter.add("Ja:  " + writeMessage);
                break;
            case MESSAGE_READ:
                byte[] readBuf = (byte[]) msg.obj;
                // utwrz acuch z bufora
                String readMessage = new String(readBuf, 0, msg.arg1);
                mConversationArrayAdapter.add(mConnectedDeviceName+":  " + readMessage);
                break;
            case MESSAGE_DEVICE_NAME:
                // zapisz nazw poczonego urzdzenia
                mConnectedDeviceName = msg.getData().getString(DEVICE_NAME);
                Toast.makeText(getApplicationContext(), "Podczony do  "
                               + mConnectedDeviceName, Toast.LENGTH_SHORT).show();
                break;
            case MESSAGE_TOAST:
                Toast.makeText(getApplicationContext(), msg.getData().getString(TOAST),
                               Toast.LENGTH_SHORT).show();
                break;
            }
        }
    };

    public void onActivityResult(int requestCode, int resultCode, Intent data) {

        switch (requestCode) {
        case REQUEST_CONNECT_DEVICE:
            // Kiedy DeviceListActivity zwraca urzdzenie do poczenia
            if (resultCode == Activity.RESULT_OK) {
                // pobierz adres MAC
                String address = data.getExtras()
                                     .getString(DeviceListActivity.EXTRA_DEVICE_ADDRESS);
                // Pobierz obiekt BLuetoothDevice 
                BluetoothDevice device = BlueAdapter.getRemoteDevice(address);
                // Podejmij prb poczenia
                mChatService.connect(device);
            }
            break;
        case REQUEST_ENABLE_BT:
            // Kiedy zakoczy si danie wczenia Bluetooth
            if (resultCode == Activity.RESULT_OK) {
                // Bluetooth jest wczony zakocz sesj
                startgame();
            } else {
                // Uytkownik nie wczy Bluetooth lub wystpi bd
                Log.d(TAG, "Bd inicjalizacji interfejsu Bluetooth");
                Toast.makeText(this, R.string.bt_not_enabled_leaving, Toast.LENGTH_SHORT).show();
                finish();
            }
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.option_menu, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
        case R.id.scan:
            // Uruchom  DeviceListActivity aby ujrze urzdzenia do przeszukania
            Intent serverIntent = new Intent(this, DeviceListActivity.class);
            startActivityForResult(serverIntent, REQUEST_CONNECT_DEVICE);
            return true;
        case R.id.discoverable:
            // Upewnij si e urzdzenie jest wykrywalne przez innych
            ensureDiscoverable();
            return true;
        }
        return false;
    }

}