package com.gameproject.soundstest;



import java.util.concurrent.ArrayBlockingQueue;


import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable.Callback;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorListener;
import android.media.AudioManager;
import android.media.SoundPool;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;


public class GameView extends SurfaceView implements
		SurfaceHolder.Callback, SensorEventListener {
	public class GameLogic extends Thread{

		private ArrayBlockingQueue<InputObject> inputObjectPool;
		boolean loaded = false;
		private SoundPool soundPool;
		
		private int ID_robot_noise;
		private int ID_alien_noise;
		private int ID_human_noise;
		private int game_state;
	    public static final int PAUSE = 0;
	    public static final int READY = 1;
	    public static final int RUNNING = 2;
	    private ArrayBlockingQueue<InputObject> inputQueue = new ArrayBlockingQueue<InputObject>(20);
	    private Object inputQueueMutex = new Object();
		private SurfaceHolder surfaceholder;
		private Context context;
		private SpriteObject sprite;
		
		
        public GameLogic(SurfaceHolder surfHold, Context con) {
            // get handles to some important objects
            surfaceholder = surfHold;
            context = con;
    		sprite = new SpriteObject(BitmapFactory.decodeResource(getResources(), R.drawable.star), 50, 50);
    		//soundPool = new SoundPool(10, AudioManager.STREAM_MUSIC, 0);
    		//Log.d("STUPID","soundpool started");
    		
    		
    		//ID_robot_noise = soundPool.load(context, R.raw.robot_noise, 1);
    		//Log.d("robot:", Integer.toString(ID_robot_noise));
        	//ID_alien_noise = soundPool.load(context, R.raw.alien_noise, 2);
    		//Log.d("alien:", Integer.toString(ID_alien_noise));
        	//ID_human_noise = soundPool.load(context, R.raw.human_noise, 3);
        }
        
        
    	public void run(){
    		
    		while (game_state == RUNNING) {
    			//long time_orig = System.currentTimeMillis();
    			//long time_interim;
    			Canvas canvas;
    			
    			canvas = null;
    			try {
    				
    				canvas = surfaceholder.lockCanvas(null);
    				synchronized (surfaceholder) {
    	              /* try {
    	                    Thread.sleep(30);
    	                } catch (InterruptedException e1) {
    	                }*/

    	                //time_interim = System.currentTimeMillis(); 
    	                //int adj_mov = (int)(time_interim - time_orig);
    	                update(2);
    	                //time_orig = time_interim; 
    					DrawScreen(canvas);				
    				}
    			} 
    			finally {
    				if (canvas != null) {
    					surfaceholder.unlockCanvasAndPost(canvas);
    				}
    			}
    		}
	}
    	
    	
    	
    	
    	
    	public void setGameState(int gamestate) {
    		this.game_state = gamestate;
    	}
    	public int getGameState(){
    		return game_state;
    	}	
    	
    	public void feedInput(InputObject input) {
    		synchronized(inputQueueMutex) {
    			try {
    				inputQueue.put(input);
    			} catch (InterruptedException e) {
    			}
    		}
    	}
    	
    	

    	public void DrawScreen(Canvas canvas) {
    		canvas.drawColor(Color.RED);
    		sprite.draw(canvas);
    	}

    	
    	
    	public void update(int adj_mov) {
    		if (sprite.getX() >= getWidth()){ 
    			//sprite.setMoveX(0);
    		}
    		if (sprite.getX() <= 0){
    			//sprite.setMoveX(0);
    		}
    		sprite.update(adj_mov);

    	}
    	
    	public void processMotionEvent(InputObject input){
    		sprite.setX(input.x);
    		sprite.setY(input.y);
    	}
    	
    	public void processKeyEvent(InputObject input){
    	}

    	public void processOrientationEvent(float orientation[]){
    		
    		float roll = orientation[2];
    		if (roll < -40) {
    			//sprite.setMoveX(2);
    		} else if (roll > 40) {
    			//sprite.setMoveX(-2);
    		}
    		
	}
	}

	
	
	/*start of view class
	*
	*
	*
	*
	*
	*/
	
    private GameLogic mGameLogic;

	
	public GameView(Context context) {
		super(context);
		getHolder().addCallback(this);

        mGameLogic = new GameLogic(getHolder(), context);
		setFocusable(true);
	}

		
	@Override
	public void surfaceChanged(SurfaceHolder holder, int format, int width,
			int height) {
	}

	@Override
	public void surfaceCreated(SurfaceHolder holder) {
		mGameLogic.setGameState(mGameLogic.RUNNING);
		mGameLogic.run();
		
	}
	
	@Override
	public void surfaceDestroyed(SurfaceHolder holder) {
		mGameLogic.setGameState(mGameLogic.PAUSE);
	}	
	
	@Override
	public boolean onTouchEvent(MotionEvent event){
		return true;
		
	}




	@Override
	public void onAccuracyChanged(Sensor arg0, int arg1) {
		// TODO W tym miejscu automatycznie generowany szkielet 
		
	}


	@Override
	public void onSensorChanged(SensorEvent arg0) {
		// TODO W tym miejscu automatycznie generowany szkielet 
		
	}
	
}
