package com.gameproject.harbordefender;


import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
 
public class MainActivity extends Activity implements SensorEventListener{
    

    

	
	
	GameView mGameView;
    private SensorManager mSensorManager;
    private Sensor mAccelerometer;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mGameView = new GameView(this);
        setContentView(mGameView);
        //mGameView = (GameView) findViewById(R.id.harbordefender);
        //mGameView.setTextView((TextView) findViewById(R.id.text));
        
        //setContentView(R.layout.main);
        mSensorManager = (SensorManager)getSystemService(SENSOR_SERVICE);
        mAccelerometer = mSensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);

        
       /* final Button button = (Button) findViewById(R.id.startgame);
        button.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {

                setContentView(mGameView);
            }
        }); */
    	
    }
    
    protected void onResume() {
        super.onResume();
        mSensorManager.registerListener(this, mAccelerometer, SensorManager.SENSOR_DELAY_NORMAL);
    }

    protected void onPause() {
        super.onPause();
        mSensorManager.unregisterListener(this);
    }
    
    
	@Override
	public void onAccuracyChanged(Sensor arg0, int arg1) {
		// TODO W tym miejscu automatycznie generowany szkielet 
		
	}
	
	
	@Override
	public void onSensorChanged(SensorEvent event) {

	if(event.sensor.getType() == Sensor.TYPE_ACCELEROMETER){
		float orientation[] = new float[3];
		for(int i = 0; i < 3; i++){
			orientation[i] = event.values[i];
		}
		
		mGameView.processOrientationEvent(orientation);
		
		Log.d("azymuth",Float.toString(event.values[0]));
		Log.d("pochylenie",Float.toString(event.values[1]));
		Log.d("przechylenie",Float.toString(event.values[2]));
	}


	}
    

}

