package com.gameproject.graphicstest;


import android.graphics.Canvas;
import android.view.SurfaceHolder;
import java.lang.Thread;
import android.util.Log;

public class GameLogic extends Thread {
	
	private SurfaceHolder surfaceHolder;
	private GameView mGameView;
	private int game_state;
    public static final int PAUSE = 0;
    public static final int READY = 1;
    public static final int RUNNING = 2;
	
    
	public GameLogic(SurfaceHolder surfaceHolder, GameView mGameView) {
		super();
		this.surfaceHolder = surfaceHolder;
		this.mGameView = mGameView;
	}
	
    
	public void setGameState(int gamestate) {
		this.game_state = gamestate;
	}
	public int getGameState(){
		return game_state;
	}



	@Override
	public void run() {
		long time_orig = System.currentTimeMillis();
		long time_interim;
		Canvas canvas;
		
		
		while (game_state == RUNNING) {
			canvas = null;
			try {
				
				canvas = this.surfaceHolder.lockCanvas();
				
				synchronized (surfaceHolder) {
	               try {
	                    Thread.sleep(30);
	                } catch (InterruptedException e1) {
	                }

	                time_interim = System.currentTimeMillis(); 
	                int adj_mov = (int)(time_interim - time_orig);
	                mGameView.update(adj_mov); 
	        		Log.d("message", Integer.toString(adj_mov));
	                time_orig = time_interim; 
					this.mGameView.onDraw(canvas);				
				}
			} 
			finally {
				if (canvas != null) {
					surfaceHolder.unlockCanvasAndPost(canvas);
				}
			}
		}
	}
	
}
