package com.manning.aip.location;

import android.app.Activity;
import android.content.Context;
import android.location.GpsSatellite;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Bundle;
import android.util.Printer;
import android.util.StringBuilderPrinter;
import android.widget.TextView;

import java.util.ArrayList;

// UWAGA: dostawca "network" zawsze zwraca null w metodzie getLastKnownLocation, jeli
// opcja settings/location and security/Use wireless networks NIE JEST WCZONA
// (to czsta sytuacja).

public class ProviderDetail extends Activity {

   private LocationManager locationMgr;

   private TextView title;
   private TextView detail;

   @Override
   protected void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);
      setContentView(R.layout.title_detail);

      locationMgr = (LocationManager) getSystemService(Context.LOCATION_SERVICE);

      title = (TextView) findViewById(R.id.title);
      detail = (TextView) findViewById(R.id.detail);
   }

   @Override
   protected void onResume() {
      super.onResume();

      String providerName = getIntent().getStringExtra("PROVIDER_NAME");
      Location lastLocation = locationMgr.getLastKnownLocation(providerName);
      LocationProvider provider = locationMgr.getProvider(providerName);

      StringBuilder sb = new StringBuilder();

      sb.append("Informacje z menedera pooenia");
      sb.append("\n--------------------------------");
      if (lastLocation != null) {
         sb.append("\n");
         Printer printer = new StringBuilderPrinter(sb);
         lastLocation.dump(printer, "Ostatnie pooenie: ");
      } else {
         sb.append("\nOstatnie pooenie: brak\n");
      }
     
      sb.append("\n");
      sb.append("\nCechy dostawcy");
      sb.append("\n--------------------------------");
      sb.append("\nDokadno: " + provider.getAccuracy());
      sb.append("\nZuycie energii: " + provider.getPowerRequirement());
      sb.append("\nWymaga opat: " + provider.hasMonetaryCost());
      sb.append("\nOkrela wysoko: " + provider.supportsAltitude());
      sb.append("\nOkrela azymut: " + provider.supportsBearing());
      sb.append("\nOkrela szybko: " + provider.supportsSpeed());
      sb.append("\nWymaga sieci komrkowej: " + provider.requiresCell());
      sb.append("\nWymaga sieci z danymi: " + provider.requiresNetwork());
      
      // Dodatkowe informacje dla dostawcy GPS
      if (providerName.equalsIgnoreCase(LocationManager.GPS_PROVIDER)) {
         GpsStatus gpsStatus = locationMgr.getGpsStatus(null);
         sb.append("\nStatus: ");
         sb.append("\n--------------------------------");
         sb.append("\nCzas do ustalenia pooenia: " + gpsStatus.getTimeToFirstFix());
         sb.append("\nMaks. liczba satelit: " + gpsStatus.getMaxSatellites());
         ArrayList<GpsSatellite> satellites = new ArrayList<GpsSatellite>();
         for (GpsSatellite satellite : gpsStatus.getSatellites()) {
            satellites.add(satellite);
         }
         sb.append("\nObecna liczba satelit: " + satellites.size());
         if (satellites.size() > 0) {
            for (GpsSatellite satellite : satellites) {
               sb.append("\nSatelita: " + satellite.getPrn());
               sb.append("\n   azymut " + satellite.getAzimuth());
               sb.append("\n   wysoko " + satellite.getElevation());
               sb.append("\n   sygna do szumu " + satellite.getSnr());
            }
         }
      }

      title.setText("Dostawca: " + providerName);
      detail.setText(sb.toString());
   }
}