package com.manning.aip.mymoviesdatabase.model;

public class Category extends ModelBase implements Comparable<Category> {

   // UWAGA: w produkcyjnej aplikacji warto uy klasy CategoryFactory lub
   // metody fabrycznej, aby ograniczy liczb tworzonych obiektw. Liczba 
   // kategorii jest maa i s one proste, dlatego nie trzeba nieustannie 
   // odtwarza obiektw reprezentujcych te same acuchy znakw.  

   private String name;

   public Category() {
   }

   public Category(long id, String name) {
      this.id = id;
      this.name = name;
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   @Override
   public String toString() {
      return this.name;
   }

   @Override
   public int compareTo(Category another) {
      if (another == null) {
         return -1;
      }
      if (this.name == null) {
         return 1;
      }
      return this.name.compareTo(another.name);
   }

   @Override
   public int hashCode() {
      final int prime = 31;
      int result = super.hashCode();
      // Zmiana liter w tytuach na due, aby metoda hashCode dziaaa tak jak equals 
      // (w equals wielko liter jest ignorowana)
      result = prime * result + ((this.name == null) ? 0 : this.name.toUpperCase().hashCode());
      return result;
   }

   @Override
   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      }
      if (!super.equals(obj)) {
         return false;
      }
      if (!(obj instanceof Category)) {
         return false;
      }
      Category other = (Category) obj;
      if (this.name == null) {
         if (other.name != null) {
            return false;
            // Przy sprawdzaniu tytuw wielko liter jest ignorowana
         }
      } else if (!this.name.equalsIgnoreCase(other.name)) {
         return false;
      }
      return true;
   }
}
