package com.manning.aip.portfolio;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Klasa ze struktur danych reprezentujc akcje. Obejmuje implementacj interfejsu
 * {@link http://developer.android.com/reference/android/os/Parcelable.html Parcelable},
 * dlatego klas mona uywa do komunikacji midzyprocesowej midzy dziaajc w tle usug
 * a aktywnoci.
 * 
 * @author Michael Galpin
 *
 */
public class Stock implements Parcelable{
	// Okrelane przez uytkownika.
	private String symbol;
	private double maxPrice;
	private double minPrice;
	private double pricePaid;
	private int quantity;
	
	// Dynamicznie pobierane.
	private String name ="";
	private double currentPrice=0D;
	
	// Okrelane przez baz danych.
	private int id;
	
	// Konstruktory.
	public Stock(String symbol, double pricePaid, int quantity) {
		this(symbol, pricePaid, quantity, 0);
	}
	public Stock(String symbol, double pricePaid, int quantity, int id) {
		this.symbol = symbol;
		this.pricePaid = pricePaid;
		this.quantity = quantity;
		this.id = id;
	}
	public Stock(Stock old, int id){
		this.symbol = old.symbol;
		this.maxPrice = old.maxPrice;
		this.minPrice = old.minPrice;
		this.pricePaid = old.pricePaid;
		this.quantity = old.quantity;
		this.name = old.name;
		this.currentPrice = old.currentPrice;
		this.id = id;
	}
	private Stock(Parcel parcel){
		this.readFromParcel(parcel);
	}
	
	// Procedury pobierajce i ustawiajce.
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public double getCurrentPrice() {
		return currentPrice;
	}
	public void setCurrentPrice(double currentPrice) {
		this.currentPrice = currentPrice;
	}
	public String getSymbol() {
		return symbol;
	}
	public double getMaxPrice() {
		return maxPrice;
	}
	public double getMinPrice() {
		return minPrice;
	}
	public double getPricePaid() {
		return pricePaid;
	}
	public int getQuantity() {
		return quantity;
	}
	public void setMaxPrice(double maxPrice) {
		this.maxPrice = maxPrice;
	}
	public void setMinPrice(double minPrice) {
		this.minPrice = minPrice;
	}
	public int getId() {
		return id;
	}
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		if (name != null){
			sb.append(name).append(' ');
		}
		sb.append('(').append(symbol.toUpperCase()).append(')')
			.append(" $").append(currentPrice);
		return sb.toString();
	}
	/**
	 * Klasa z implementacj interfejsu <code>Parcelable</code> wymaga
	 * statycznego pola CREATOR, ktre dziaa jak klasa fabryczna.
	 */
	public static final Parcelable.Creator<Stock> CREATOR = new Parcelable.Creator<Stock>() {

		public Stock createFromParcel(Parcel source) {
			return new Stock(source);
		}

		public Stock[] newArray(int size) {
			return new Stock[size];
		}
	};
	
	public int describeContents() {
		return 0;
	}
	
	@Override
	public void writeToParcel(Parcel parcel, int flags) {
		parcel.writeString(symbol);
		parcel.writeDouble(maxPrice);
		parcel.writeDouble(minPrice);
		parcel.writeDouble(pricePaid);
		parcel.writeInt(quantity);
		parcel.writeDouble(currentPrice);
		parcel.writeString(name);
	}
	
	/**
	 * Metoda do tworzenia obiektu klasy <code>Stock</code> na podstawie obiektu typu <code>Parcelable</code>.
	 * Metoda ta nie jest wymagana w interfejsie <code>Parcelable</code>; zamiast tego mona 
	 * wykorzysta metod <code>createFromParcel</code> z obiektu  
	 * <code>Parcelable.Creator</code>.
	 * 
	 * @param 	parcel			Obiekt typu <code>Parcelable</code> uywany do tworzenia obiektu
	 * 							klasy <code>Stock</code>. Zakadamy, e jest to obiekt klasy
	 * 							<code>Stock</code> zserializowany za pomoc  
	 * 							metody {@link #writeToParcel(Parcel, int) writeToParcel}
	 * 							
	 */
	public void readFromParcel(Parcel parcel){
		symbol = parcel.readString();
		maxPrice = parcel.readDouble();
		minPrice = parcel.readDouble();
		pricePaid = parcel.readDouble();
		quantity = parcel.readInt();
		currentPrice = parcel.readDouble();
		name = parcel.readString();
	}
}
