package com.manning.aip.portfolio;

import java.util.Calendar;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

/**
 * Odbiornik <code>BroadcastReceiver</code> powiadamiany o rozruchu urzdzenia.
 * Uywa klasy {@link http://developer.android.com/reference/android/app/AlarmManager.html AlarmManager}
 * do planowania regularnych wywoa usugi 
 * {@link com.manning.aip.portfolio.PorfolioManagerService PortfolioManagerService}.
 * 
 * Kod mona atwo zmodyfikowa, aby uywa usugi Cloud to Device Messaging. Szczegy znajdziesz
 * w komentarzach.
 * 
 * @author Michael Galpin
 *
 */
public class PortfolioStartupReceiver extends BroadcastReceiver {
	private static final int FIFTEEN_MINUTES = 15*60*1000;

	// Usu komentarz pod sta, aby uy usugi C2DM. W puste pole wstaw adres e-mail 
	// uywany do przesyania aplikacji do sklepu Android Market.
	//private static final String DEVELOPER_EMAIL_ADDRESS = "";
	
	@Override
	public void onReceive(Context context, Intent intent) {
		
		// Pocztek kodu opartego na klasie AlarmManager. Usu ten kod, aby uy usugi C2DM.
		AlarmManager mgr = 
			(AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
		Intent i = new Intent(context, AlarmReceiver.class);
		PendingIntent sender = PendingIntent.getBroadcast(context, 0, 
				i, PendingIntent.FLAG_CANCEL_CURRENT);
		Calendar now = Calendar.getInstance();
		now.add(Calendar.MINUTE, 2);
		mgr.setRepeating(AlarmManager.RTC_WAKEUP, 
				now.getTimeInMillis(), FIFTEEN_MINUTES, sender);
		// Koniec kodu opartego na klasie AlarmManager.
		
		// Usu komentarze, aby uy usugi C2DM.
//		Intent registrationIntent = new Intent("com.google.android.c2dm.intent.REGISTER");
//		registrationIntent.putExtra("app", PendingIntent.getBroadcast(context, 0, new Intent(), 0));
//		registrationIntent.putExtra("sender", DEVELOPER_EMAIL_ADDRESS);
//		context.startService(registrationIntent);
	}
}