package com.manning.aip.tabdroid;

import com.manning.aip.dealdroid.Constants;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class DealBootReceiver extends BroadcastReceiver {

   @Override
   public void onReceive(Context context, Intent intent) {
      Log.i(Constants.LOG_TAG, "Wywoano odbiornik DealBootReceiver. Konfigurowanie obiektu klasy AlarmManager");
      AlarmManager alarmMgr = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
      PendingIntent pendingIntent =
               PendingIntent.getBroadcast(context, 0, new Intent(context, DealAlarmReceiver.class), 0);

   // Stosowanie powtrze w przyblionym czasie zmniejsza zuycie energii 
      // (system moe stopniowo zgasza zdarzenia i nie musi wzbudza urzdzenia 
      // w cile okrelonym czasie).
      alarmMgr.setInexactRepeating(AlarmManager.ELAPSED_REALTIME_WAKEUP, Constants.ALARM_TRIGGER_AT_TIME,
               Constants.ALARM_INTERVAL, pendingIntent);
   }
}
