/**
 * 
 */
package com.manning.aip.canvasdemo;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Typeface;
import android.view.View;

/**
 * Widok do wywietlania czcionki typu TrueType za pomoc obiektu klasy Canvas.
 * 
 * @author tamas
 * 
 */
public class ShapesAndTextFontView extends View {

   private Paint paint;
   private Typeface font;
   private String text;

   public ShapesAndTextFontView(Context context) {
      super(context);
      // Wczytywanie czcionki.
      font = Typeface.createFromAsset(context.getAssets(), "256bytes.ttf");
   }

   public void setText(String text) {
      this.text = text;
   }

   @Override
   protected void onDraw(Canvas canvas) {
      canvas.drawRGB(0, 0, 0);
      drawShapes(canvas);
      drawText(canvas);
   }

   private void drawShapes(Canvas canvas) {
      // Rysowanie czerwonego kwadratu, zielonego kka i niebieskiego trjkta
	  // w dolnej czci ekranu.
      int side = canvas.getWidth() / 5;
      paint = new Paint();
      paint.setARGB(255, 255, 0, 0);
      canvas.drawRect(side, canvas.getHeight() - 60 - side, side + side, canvas.getHeight() - 60, paint);
      paint.setARGB(255, 0, 255, 0);
      canvas.drawCircle(side * 2 + side / 2, canvas.getHeight() - 60 - side / 2, side / 2, paint);
      paint.setARGB(255, 0, 0, 255);
      paint.setStyle(Paint.Style.FILL);
      Path triangle = new Path();
      triangle.moveTo(side * 3 + 30, canvas.getHeight() - 60 - side);
      triangle.lineTo(side * 3 + 60, canvas.getHeight() - 60);
      triangle.lineTo(side * 3, canvas.getHeight() - 60);
      triangle.lineTo(side * 3 + 30, canvas.getHeight() - 60 - side);
      canvas.drawPath(triangle, paint);
   }

   private void drawText(Canvas canvas) {
      paint.setColor(Color.WHITE);
      paint.setTextSize(40);
      paint.setTypeface(font);
      canvas.drawText(text, 60, 300, paint);
   }
}
