package com.manning.aip.portfolio;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

/**
 * Odbiornik <code>BroadcastReceiver</code> uywany do odbierania zdarze od
 * usugi Cloud to Device Messaging (C2DM). 
 * 
 * @author Michael Galpin
 *
 */
public class PushReceiver extends BroadcastReceiver {
	
	@Override
	public void onReceive(Context context, Intent intent) {
		AlarmReceiver.acquireLock(context);
	    if (intent.getAction().equals(
	    		"com.google.android.c2dm.intent.REGISTRATION")) {
	        onRegistration(context, intent);
	    } else if (intent.getAction().equals(
	    		"com.google.android.c2dm.intent.RECEIVE")) {
	        onMessage(context, intent);
	     }
	 }
	
	/**
	 * Ta metoda suy do obsugi zdarzenia rejestracji zgaszanego przez usug
	 * C2DM.
	 * 
	 * @param 	context			Obiekt klasy <code>Context</code> zdarzenia
	 * @param 	intent			Intencja przekazana przez usug C2DM
	 */
	private void onRegistration(Context context, Intent intent) {
		String regId = intent.getStringExtra("registration_id"); 
		if (regId != null) {
			Intent i = new Intent(context, SendC2dmRegistrationService.class);
			i.putExtra("regId", regId);
			context.startService(i);
		}
	}
	
	/**
	 * Ta metoda obsuguje zdarzenia zgoszone przez serwery poprzez usug
	 * C2DM.
	 * 
	 * @param 	context			Obiekt klasy <code>Context</code> zdarzenia
	 * @param 	intent			Intencja przekazana przez usug C2DM
	 */
	private void onMessage(Context context, Intent intent){
		Intent stockService = 
			new Intent(context, PortfolioManagerService.class);
		// Kopiowanie danych przesanych przez serwer
		stockService.putExtras(intent);
		context.startService(stockService);
	}
}
