package com.manning.aip.mymoviesdatabase.util;

import android.graphics.Bitmap;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * "Naiwna" pami podrczna oparta na metodzie removeEldestEntry klasy HashMap.
 * 
 * @author ccollins
 *
 */
@SuppressWarnings("serial")
public class ImageCache {

   private static final int IMAGE_CACHE_SIZE = 250;

   private final Map<String, Bitmap> cache;

   // Kolekcja ronie tylko do okrelonego rozmiaru. Uycie klasy WeakHashMap jest tu zym 
   // pomysem, poniewa w klasie tej uywa si sabych referencji do kluczy.
   public ImageCache() {
      this.cache =
               Collections.synchronizedMap(new LinkedHashMap<String, Bitmap>(ImageCache.IMAGE_CACHE_SIZE + 1, .75F,
                        true) {
                  @Override
                  public boolean removeEldestEntry(Map.Entry<String, Bitmap> eldest) {
                     return size() > ImageCache.IMAGE_CACHE_SIZE;
                  }
               });
   }

   public Bitmap get(String urlString) {
      return this.cache.get(urlString);
   }

   public void put(String urlString, Bitmap bitmap) {
      this.cache.put(urlString, bitmap);
   }
}
