package com.manning.aip.portfolio;

import android.app.Activity;
import android.os.Bundle;
import android.widget.TextView;

/**
 * Aktywno uruchamiana po otwarciu powiadomienia.
 * 
 * @author Michael Galpin
 *
 */
public class NotificationDetails extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		this.setContentView(R.layout.details);
		
		Stock stock = (Stock) this.getIntent().getParcelableExtra("stock");
		TextView nameLabel = (TextView) findViewById(R.id.name);
		if (stock == null){
			nameLabel.setText("Brak akcji do wywietlenia");
			return;
		}
		
		nameLabel.setText(stock.getName() + "(" + stock.getSymbol() + ")");
		
		double current = stock.getCurrentPrice();
		TextView currentLabel = (TextView) findViewById(R.id.current);
		currentLabel.setText("Obecna cena: $" + current);
		
		TextView minLabel = (TextView) findViewById(R.id.min);
		if (current < stock.getMinPrice()){
			minLabel.setText("Obecna cena jest nisza od minimum rwnego " + 
					stock.getMinPrice());
			minLabel.setTextColor(0xFFFF0000);
		} else {
			minLabel.setText("Minimalna cena: $" + stock.getMinPrice());
		}
		
		TextView maxLabel = (TextView) findViewById(R.id.max);
		if (current > stock.getMaxPrice()){
			maxLabel.setText("Obecna cena jest wysza od maksimum rwnego " + 
					stock.getMaxPrice());
			maxLabel.setTextColor(0xFF00FF00);
		} else {
			maxLabel.setText("Maksymalna cena: $" + stock.getMaxPrice());
		}
	}

}
