package com.manning.aip.tabdroid;

import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.SystemClock;
import android.util.Log;

import java.util.ArrayList;
import java.util.List;

import com.manning.aip.dealdroid.Constants;
import com.manning.aip.dealdroid.DealsApp;

//Klasa IntentService kolejkuje wywoania startService(Intent) za pomoc onHandleIntent i koczy prac.
//
//UWAGA: w tej implementacji celowo nie uywamy klas PowerManager/WakeLock ani nie uwzgldniamy problemw z energi.
//Jeli urzdzenie jest upione, AlarmManager wzbudza je przy zdarzeniu onReceiver odbiornika
//BroadcastReceiver, ale nastpnie znw urzdzenie moe przej w stan upienia.
//Mona uy obiektu PowerManager i zaj blokad WakeLock, jednak take to podejcie
//nie jest doskonae. 
//Problem mona rozwiza, jednak w tym przykadzie takie komplikacje nie sa konieczne.
//Nic si nie stanie, jeli uytkownik nie zobaczy nowych ofert do momentu uruchomienia telefonu
//i przesania powiadomie.

public class DealService extends IntentService {

   private static int count;

   private DealsApp app;

   public DealService() {
      super("Deal Service");
   }

   @Override
   public void onStart(Intent intent, int startId) {
      super.onStart(intent, startId);
   }

   @Override
   public void onHandleIntent(Intent intent) {
      Log.i(Constants.LOG_TAG, "Wywoano DealService; wyszukiwanie nowy ofert (powiadamia o obecnoci)");
      this.app = (DealsApp) getApplication();
      if (app.connectionPresent()) {
         // Przetwarzanie danych z kanau RSS.
         app.sectionList = app.parser.parse();

         // Pobieranie listy identyfikatorw currentDealIds z pierwszej kategorii 
         // (Daily Deals, zawsze 4 elementy).
         List<Long> currentDealIds = app.parseItemsIntoDealIds(app.sectionList.get(0).items);         

         // Poprzednie oferty s zapisane jako ustawienia, poniewa proste dane atwiej przechowywa w ten sposb 
         // ni w plikach. Ponadto potrzebny jest trway mechanizm na dane po wznowieniu pracy usugi 
         // (pami aplikacji moe zosta wyczyszczona).
         List<Long> previousDealIds = app.getPreviousDealIdsFromPrefs();

         // Zapisywanie obecnego identyfikatora currentDealIds jako 
         // dawnego, co zapewnia aktualne dane przy pniejszym wznowieniu.
         app.setPreviousDealIdsToPrefs(currentDealIds);

         // Czy istniej NOWE identyfikatory?
         List<Long> newDealIdsList = this.checkForNewDeals(previousDealIds, currentDealIds);
         if (!newDealIdsList.isEmpty()) {
            this.sendNotification(this, newDealIdsList.size());
         }
                
         count++;
         if (count == 1) {
            SystemClock.sleep(5000);
            this.sendNotification(this, 1);
         }
         
      } else {
         Log.w(Constants.LOG_TAG, "Brak poczenia; nie mona sprawdzi ofert");
      }
   }

   // Zamiast uywa caego elementu, korzystamy z pola itemId; 
   // jest unikatowe i pozwala stwierdzi, ktre oferty s nowe.         
   private List<Long> checkForNewDeals(final List<Long> previousDealIds, final List<Long> currentDealIds) {
      List<Long> newDealsList = new ArrayList<Long>();
      for (Long id : currentDealIds) {
         if ((id != 0) && !previousDealIds.contains(id)) {
            Log.d(Constants.LOG_TAG, "Znaleziono nowe oferty: " + id);
            newDealsList.add(id);
         }
      }
      return newDealsList;
   }

   private void sendNotification(final Context context, final int numNewDeals) {
      Intent notificationIntent = new Intent(context, DealsMain.class);
      notificationIntent.putExtra(Constants.FORCE_RELOAD, true);
      PendingIntent contentIntent = PendingIntent.getActivity(context, 0, notificationIntent, 0);

      NotificationManager notificationMgr =
               (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
//      Notification notification =
//               new Notification(android.R.drawable.star_on, getString(R.string.deal_service_ticker), System
//                        .currentTimeMillis());
//      notification.flags |= Notification.FLAG_AUTO_CANCEL;
//      notification.setLatestEventInfo(context, getResources().getString(R.string.deal_service_title), getResources()
//               .getQuantityString(R.plurals.deal_service_new_deal, numNewDeals, numNewDeals), contentIntent);
//      notificationMgr.notify(0, notification);
      Resources res = getResources();
      Notification.Builder builder = new Notification.Builder(this);
      builder.setContentIntent(contentIntent)
      	.setSmallIcon(android.R.drawable.star_on)
      	.setLargeIcon(BitmapFactory.decodeResource(res, R.drawable.ddicon))
      	.setTicker(res.getString(R.string.deal_service_ticker))
      	.setWhen(System.currentTimeMillis())
      	.setAutoCancel(true)
      	.setNumber(numNewDeals)
      	.setContentTitle(res.getString(R.string.deal_service_title))
      	.setContentText(res.getQuantityString(
      			R.plurals.deal_service_new_deal, numNewDeals, numNewDeals));
      Notification n = builder.getNotification();
      notificationMgr.notify(0, n);
   }
}
