package com.manning.aip.mymoviesdatabase.data.backup;

import android.app.backup.BackupManager;
import android.content.Context;

/**
 * Uywanie nakadki na klas BackupManager, poniewa standardowa wersja tej 
 * klasy jest dostpna tylko od wersji 8. API.
 * 
 * @author ccollins
 *
 */
public class BackupManagerWrapper {
   private BackupManager instance;

   static {
      try {
         Class.forName("android.app.backup.BackupManager");
      } catch (Exception e) {
         throw new RuntimeException(e);
      }
   }

   public static void isAvailable() {
   }

   public BackupManagerWrapper(final Context context) {
      instance = new BackupManager(context);
   }

   public void dataChanged() {
      instance.dataChanged();
   }
}
