package com.manning.aip;

import java.net.URL;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

public class SimpleImageDownload extends Activity {

   private Runnable imageDownloader = new Runnable() {

      public void run() {
         try {
            URL imageUrl = new URL("http", "android.com", "/images/froyo.png");
            Bitmap image = BitmapFactory.decodeStream(imageUrl.openStream());
            if (image != null) {
               Log.i("DL", "Pobrano plik!");
            } else {
               Log.i("DL", "Bd przy wczytywaniu pliku ze strumienia");
            }
         } catch (Exception e) {
            Log.i("DL", "Nieudane pobieranie pliku!");
            e.printStackTrace();
         }
      }
   };

   public void startDownload(View source) {
      new Thread(imageDownloader, "Wtek pobierajcy plik").start();
      TextView statusText = (TextView) findViewById(R.id.status);
      statusText.setText("Rozpoczto pobieranie...");
   }

   @Override
   public void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);
      setContentView(R.layout.main);
   }
}