package com.manning.aip.location;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.GpsSatellite;
import android.location.GpsStatus;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.util.Log;
import android.widget.TextView;

public class GetLocationWithGPS extends Activity {

   public static final String LOC_DATA = "LOC_DATA";

   private LocationManager locationMgr;
   private GpsListener gpsListener;
   private GpsStatus gpsStatus;
   private Handler handler;

   private TextView title;
   private TextView detail;
   private TextView gpsEvents;
   private TextView satelliteStatus;

   @Override
   protected void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);
      setContentView(R.layout.get_location);

      title = (TextView) findViewById(R.id.title);
      detail = (TextView) findViewById(R.id.detail);
      gpsEvents = (TextView) findViewById(R.id.gps_events);
      satelliteStatus = (TextView) findViewById(R.id.satellite_status);

      title.setText("Okrel pooenie za pomoc GPS-a");
      detail.setText("Prba okrelenia pooenia...\n     (moe zaj kilka sekund)");

      locationMgr = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
      gpsListener = new GpsListener();

      handler = new Handler() {
         public void handleMessage(Message m) {
            Log.d(Main.LOG_TAG, "Komunikat z komponentu obsugi: " + m.toString());
            if (m.what == LocationHelper.MESSAGE_CODE_LOCATION_FOUND) {
               detail.setText("KOMPONENT OBSUGI:\nszer.:" + m.arg1 + "\nd.:" + m.arg2);
            } else if (m.what == LocationHelper.MESSAGE_CODE_LOCATION_NULL) {
               detail.setText("KOMPONENT OBSUGI:\nnie mona okreli pooenia");
            } else if (m.what == LocationHelper.MESSAGE_CODE_PROVIDER_NOT_PRESENT) {
               detail.setText("KOMPONENT OBSUGI:\nbrak dostawcy");
            }
         }
      };
   }

   @Override
   protected void onResume() {
      super.onResume();

      // Okrelanie, czy GPS jest wczony. Jeli nie, aplikacja wywietla prob
      // o jego wczenie.
      if (!locationMgr.isProviderEnabled(android.location.LocationManager.GPS_PROVIDER)) {
         AlertDialog.Builder builder = new AlertDialog.Builder(this);
         builder.setTitle("GPS nie jest wczony")
                  .setMessage("Chcesz przej do ustawie i wczy GPS?").setCancelable(true)
                  .setPositiveButton("Tak", new DialogInterface.OnClickListener() {
                     public void onClick(DialogInterface dialog, int id) {
                        startActivity(new Intent(Settings.ACTION_SECURITY_SETTINGS));
                     }
                  }).setNegativeButton("Nie", new DialogInterface.OnClickListener() {
                     public void onClick(DialogInterface dialog, int id) {
                        dialog.cancel();
                        finish();
                     }
                  });
         AlertDialog alert = builder.create();
         alert.show();
      } else {
         LocationHelper locationHelper = new LocationHelper(locationMgr, handler, Main.LOG_TAG);
         // Nie uywamy okna progressDialog, poniewa nie chcemy blokowa 
         // caego interfejsu uytkownika. W razie potrzeby mona jednak
         // to zrobi.
         locationHelper.getCurrentLocation(30);
      }

      locationMgr.addGpsStatusListener(gpsListener);
   }

   @Override
   protected void onPause() {
      super.onPause();
      locationMgr.removeGpsStatusListener(gpsListener);
   }

   // Mona te uy klasy GpsListener do otrzymywania powiadomie o 
   // uruchomieniu i zatrzymaniu GPS-a oraz ustaleniu pooenia.
   private class GpsListener implements GpsStatus.Listener {
      public void onGpsStatusChanged(int event) {
         Log.d("GpsListener", "Zmiana statusu na " + event);
         switch (event) {
            case GpsStatus.GPS_EVENT_STARTED:
               gpsEvents.setText("GPS_EVENT_STARTED");
               break;
            case GpsStatus.GPS_EVENT_STOPPED:
               gpsEvents.setText("GPS_EVENT_STOPPED");
               break;
            // Zdarzenie GPS_EVENT_SATELLITE_STATUS jest czsto wywoywane.
            // Wszystkie uywane satelity je powoduj, dlatego nie naley
            // posugiwa si tylko tym zdarzeniem.
            case GpsStatus.GPS_EVENT_SATELLITE_STATUS:
               // To rozwizanie generuje wywietla duo informacji i jest potrzebne tylko 
               // w zaawansowanych sytuacjach. Unikaj go, jeli nie jest konieczne 
               gpsStatus = locationMgr.getGpsStatus(gpsStatus);
               StringBuilder sb = new StringBuilder();
               for (GpsSatellite sat : gpsStatus.getSatellites()) {
                  sb.append("Satelita nr " + sat.getPrn() + " az.:" + sat.getAzimuth() + " wys.:" + sat.getElevation()
                           + " S/N:" + sat.getSnr() + "\n");
               }
               satelliteStatus.setText(sb.toString());
               break;
            case GpsStatus.GPS_EVENT_FIRST_FIX:
               gpsEvents.setText("GPS_EVENT_FIRST_FIX");
               break;
         }
      }
   }
}